/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.service.metadata;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dragonli.service.db.service.DBConfig;
import org.dragonli.tools.general.StringUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class TableStructure {
    public static final ConcurrentMap<Integer, Object> defaultVales = new ConcurrentHashMap<Integer, Object>();
    protected final ConcurrentMap<Object, AtomicInteger> optimisticLock = new ConcurrentHashMap<Object, AtomicInteger>();
    private DBConfig config;
    private String primaryKey;
    private String tableName;
    protected Map<String, Integer> cols = new ConcurrentHashMap<String, Integer>();
    protected String[] colList;
    protected int[] colsType;
    protected boolean[] colsNullAble;
    protected String selectAllCols;
    protected String insertAllCols;
    protected String updateAllCols;
    protected String insertSql;
    protected String delSql;
    protected String delManySql;
    protected String delMoreSql;
    protected String logicDelSql;
    protected String logicDelManySql;
    protected String logicDelMoreSql;
    protected String selectCountDisactiveSql;
    protected String selectDisactiveSql;
    private String selectMoreSql;
    private String selectCountSql;
    protected String selectSql;
    protected String selectManySql;
    protected String updateSql;
    protected boolean useActive;

    public ConcurrentMap<Object, AtomicInteger> getOptimisticLock() {
        return this.optimisticLock;
    }

    public AtomicInteger findOptimisticLock(Object pk) {
        AtomicInteger lock = (AtomicInteger)this.optimisticLock.get(pk);
        if (lock == null) {
            this.optimisticLock.putIfAbsent(pk, new AtomicInteger(0));
            lock = (AtomicInteger)this.optimisticLock.get(pk);
        }
        return lock;
    }

    public DBConfig getConfig() {
        return this.config;
    }

    public String getSelectManySql() {
        return this.selectManySql;
    }

    public String getSelectMoreSql() {
        return this.selectMoreSql;
    }

    public String getSelectCountSql() {
        return this.selectCountSql;
    }

    public String getSelectDisactiveSql() {
        return this.selectDisactiveSql;
    }

    public String getLogicDelSql() {
        return this.logicDelSql;
    }

    public String getLogicDelManySql() {
        return this.logicDelManySql;
    }

    public String getLogicDelMoreSql() {
        return this.logicDelMoreSql;
    }

    public String getDelManySql() {
        return this.delManySql;
    }

    public String getDelMoreSql() {
        return this.delMoreSql;
    }

    public boolean isUseActive() {
        return this.useActive;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, Integer> getCols() {
        return this.cols;
    }

    public String[] getColList() {
        return this.colList;
    }

    public int[] getColsType() {
        return this.colsType;
    }

    public boolean[] getColsNullAble() {
        return this.colsNullAble;
    }

    public String getSelectCountDisactiveSql() {
        return this.selectCountDisactiveSql;
    }

    public String getSelectAllCols() {
        return this.selectAllCols;
    }

    public String getInsertAllCols() {
        return this.insertAllCols;
    }

    public String getUpdateAllCols() {
        return this.updateAllCols;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public String getDelSql() {
        return this.delSql;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public TableStructure(String tableName, DBConfig config) {
        this.tableName = tableName;
        this.config = config;
        this.primaryKey = config.getPrimaryKey();
    }

    public void init(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = " select * from " + TableStructure.this.tableName + " where " + TableStructure.this.config.getPrimaryKey() + "=0 ";
                PreparedStatement ps = connection.prepareStatement(sql, 2);
                return ps;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<Boolean>(){

            public Boolean doInPreparedStatement(PreparedStatement pstmt) throws SQLException, DataAccessException {
                int i;
                pstmt.execute();
                ResultSet rs = pstmt.getResultSet();
                ResultSetMetaData data = rs.getMetaData();
                TableStructure.this.colList = new String[data.getColumnCount()];
                TableStructure.this.colsType = new int[data.getColumnCount()];
                TableStructure.this.colsNullAble = new boolean[data.getColumnCount()];
                TableStructure.this.useActive = false;
                for (i = 1; i <= data.getColumnCount(); ++i) {
                    TableStructure.this.colsType[i - 1] = data.getColumnType(i);
                    TableStructure.this.colList[i - 1] = data.getColumnName(i);
                    boolean bl = TableStructure.this.colsNullAble[i - 1] = data.isNullable(i) == 1;
                    if (TableStructure.this.config.getActiveTag() == null || !TableStructure.this.config.getActiveTag().equals(data.getColumnName(i))) continue;
                    TableStructure.this.useActive = true;
                }
                if (!TableStructure.this.colList[0].equals(TableStructure.this.config.getPrimaryKey())) {
                    int i2;
                    int index = 0;
                    int type = 0;
                    for (i2 = 0; i2 < TableStructure.this.colList.length; ++i2) {
                        if (!TableStructure.this.colList[i2].equals(TableStructure.this.config.getPrimaryKey())) continue;
                        index = i2;
                        type = TableStructure.this.colsType[i2];
                        break;
                    }
                    for (i2 = index; i2 > 0; --i2) {
                        TableStructure.this.colList[i2] = TableStructure.this.colList[i2 - 1];
                        TableStructure.this.colsType[i2] = TableStructure.this.colsType[i2 - 1];
                        TableStructure.this.colsNullAble[i2] = TableStructure.this.colsNullAble[i2 - 1];
                    }
                    TableStructure.this.colList[0] = TableStructure.this.config.getPrimaryKey();
                    TableStructure.this.colsType[0] = type;
                    TableStructure.this.colsNullAble[0] = false;
                }
                TableStructure.this.selectAllCols = TableStructure.this.config.getPrimaryKey();
                TableStructure.this.updateAllCols = "";
                TableStructure.this.insertAllCols = "";
                for (i = 1; i < TableStructure.this.colList.length; ++i) {
                    if (!TableStructure.this.selectAllCols.equals("")) {
                        TableStructure.this.selectAllCols = TableStructure.this.selectAllCols + ",";
                    }
                    if (!TableStructure.this.updateAllCols.equals("")) {
                        TableStructure.this.updateAllCols = TableStructure.this.updateAllCols + ",";
                    }
                    if (!TableStructure.this.insertAllCols.equals("")) {
                        TableStructure.this.insertAllCols = TableStructure.this.insertAllCols + ",";
                    }
                    TableStructure.this.selectAllCols = TableStructure.this.selectAllCols + TableStructure.this.colList[i];
                    TableStructure.this.updateAllCols = TableStructure.this.updateAllCols + TableStructure.this.colList[i] + "=?";
                    TableStructure.this.insertAllCols = TableStructure.this.insertAllCols + TableStructure.this.colList[i];
                }
                TableStructure.this.insertSql = "insert into {0}({1}) values ({2})";
                Object[] temp = new String[TableStructure.this.colList.length - 1];
                Arrays.fill(temp, "?");
                TableStructure.this.insertSql = StringUtil.substitute((String)TableStructure.this.insertSql, (Object[])new Object[]{TableStructure.this.tableName, TableStructure.this.insertAllCols, String.join((CharSequence)",", Arrays.asList(temp))});
                TableStructure.this.updateSql = "update {0} set {1} where {2}=?";
                TableStructure.this.updateSql = StringUtil.substitute((String)TableStructure.this.updateSql, (Object[])new Object[]{TableStructure.this.tableName, TableStructure.this.updateAllCols, TableStructure.this.config.getPrimaryKey()});
                TableStructure.this.selectSql = "select {0} from {1} where {2}=?";
                TableStructure.this.selectSql = StringUtil.substitute((String)TableStructure.this.selectSql, (Object[])new Object[]{TableStructure.this.selectAllCols, TableStructure.this.tableName, TableStructure.this.config.getPrimaryKey()});
                TableStructure.this.selectMoreSql = "select " + TableStructure.this.selectAllCols + " from " + TableStructure.this.tableName + " where 1=1 " + (TableStructure.this.useActive ? "and " + TableStructure.this.config.getActiveTag() + "=1 {0}" : "{0}");
                TableStructure.this.selectManySql = "select " + TableStructure.this.selectAllCols + " from " + TableStructure.this.tableName + " where " + TableStructure.this.config.getPrimaryKey() + " in ({0}) " + (TableStructure.this.useActive ? "and " + TableStructure.this.config.getActiveTag() + "=1 " : "");
                TableStructure.this.selectCountSql = "select count(*) from " + TableStructure.this.tableName + " where 1=1 " + (TableStructure.this.useActive ? "and " + TableStructure.this.config.getActiveTag() + "=1 {0}" : "{0}");
                TableStructure.this.delSql = "delete from {0} where {1}=?";
                TableStructure.this.delSql = StringUtil.substitute((String)TableStructure.this.delSql, (Object[])new Object[]{TableStructure.this.tableName, TableStructure.this.config.getPrimaryKey()});
                TableStructure.this.delMoreSql = "delete from " + TableStructure.this.tableName + " where 1=1 {0}";
                TableStructure.this.delManySql = "delete from " + TableStructure.this.tableName + " where " + TableStructure.this.config.getPrimaryKey() + " in ({0})";
                if (TableStructure.this.useActive) {
                    TableStructure.this.logicDelSql = "update {0} set " + TableStructure.this.config.getActiveTag() + "=0 where {1}=?";
                    TableStructure.this.logicDelSql = StringUtil.substitute((String)TableStructure.this.logicDelSql, (Object[])new Object[]{TableStructure.this.tableName, TableStructure.this.config.getPrimaryKey()});
                    TableStructure.this.logicDelManySql = "update " + TableStructure.this.tableName + " set " + TableStructure.this.config.getActiveTag() + "=0 where " + TableStructure.this.config.getPrimaryKey() + " in ({0})";
                    TableStructure.this.logicDelMoreSql = "update " + TableStructure.this.tableName + " set " + TableStructure.this.config.getActiveTag() + "=0 where 1=1 {0}";
                    TableStructure.this.selectDisactiveSql = "select " + TableStructure.this.selectAllCols + " from " + TableStructure.this.tableName + " where " + TableStructure.this.config.getActiveTag() + "=0 {0}";
                    TableStructure.this.selectCountDisactiveSql = "select count(*) from " + TableStructure.this.tableName + " where " + TableStructure.this.config.getActiveTag() + "=0";
                }
                return true;
            }
        });
    }

    static {
        defaultVales.put(2003, new byte[0]);
        defaultVales.put(-5, 0);
        defaultVales.put(-2, new byte[0]);
        defaultVales.put(-7, (byte)0);
        defaultVales.put(2004, new byte[0]);
        defaultVales.put(16, false);
        defaultVales.put(1, Character.valueOf('\u0000'));
        defaultVales.put(2005, new byte[0]);
        defaultVales.put(70, new byte[0]);
        defaultVales.put(91, new Date(0L));
        defaultVales.put(3, 0);
        defaultVales.put(2001, new byte[0]);
        defaultVales.put(8, 0.0);
        defaultVales.put(6, Float.valueOf(0.0f));
        defaultVales.put(4, 0);
        defaultVales.put(2000, new byte[0]);
        defaultVales.put(-16, "");
        defaultVales.put(-4, new byte[0]);
        defaultVales.put(-15, "");
        defaultVales.put(2011, new byte[0]);
        defaultVales.put(2, 0);
        defaultVales.put(-9, "");
        defaultVales.put(1111, new byte[0]);
        defaultVales.put(7, new byte[0]);
        defaultVales.put(2006, new byte[0]);
        defaultVales.put(2012, new byte[0]);
        defaultVales.put(-8, 0);
        defaultVales.put(5, (short)0);
        defaultVales.put(2009, "");
        defaultVales.put(2002, new byte[0]);
        defaultVales.put(92, new Time(0L));
        defaultVales.put(2013, new Time(0L));
        defaultVales.put(93, new Timestamp(0L));
        defaultVales.put(2014, new Timestamp(0L));
        defaultVales.put(-6, (byte)0);
        defaultVales.put(-3, new byte[0]);
        defaultVales.put(12, "");
    }
}

