/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.db.util;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;

public class RedisUtil {
    public static String getModelTextFromCache(String dbName, String table, Object pk, RedissonClient redissonClient, String redisKey) throws Exception {
        if (redissonClient == null || redisKey == null) {
            return null;
        }
        String json = null;
        RMap map = redissonClient.getMap(RedisUtil.redisMapKey(redisKey, dbName, table));
        json = (String)map.get((Object)pk.toString());
        return json == null ? null : json;
    }

    public static Map<String, Object> getFromCache(String dbName, String table, Object pk, RedissonClient redissonClient, String redisKey) throws Exception {
        String text = RedisUtil.getModelTextFromCache(dbName, table, pk, redissonClient, redisKey);
        return text == null ? null : JSON.parseObject((String)text);
    }

    public static void saveToCache(String dbName, String table, Object pk, Map<String, Object> model, RedissonClient redissonClient, String redisKey) throws Exception {
        RedisUtil.doSaveToCache(dbName, table, pk, model, redissonClient, redisKey);
    }

    public static void saveModelTextToCache(String dbName, String table, Object pk, String model, RedissonClient redissonClient, String redisKey) throws Exception {
        RedisUtil.doSaveToCache(dbName, table, pk, model, redissonClient, redisKey);
    }

    public static void doSaveToCache(String dbName, String table, Object pk, Object theModel, RedissonClient redissonClient, String redisKey) throws Exception {
        if (redissonClient == null || redisKey == null || theModel == null) {
            return;
        }
        String model = theModel instanceof String ? (String)theModel : JSON.toJSONString((Object)theModel);
        RMap map = redissonClient.getMap(RedisUtil.redisMapKey(redisKey, dbName, table));
        map.put((Object)pk.toString(), (Object)model);
    }

    public static void deleteFromCache(String dbName, String table, Object pk, RedissonClient redissonClient, String redisKey) {
        if (redissonClient == null || redisKey == null) {
            return;
        }
        RMap map = redissonClient.getMap(RedisUtil.redisMapKey(redisKey, dbName, table));
        map.remove((Object)pk.toString());
    }

    public static String redisMapKey(String redisKey, String dbName, String table) {
        return redisKey + RedisUtil.modelKey(dbName, table);
    }

    public static String modelKey_pk(String dbName, String table, Object pk) {
        return dbName + ":" + table + ":" + pk;
    }

    public static String modelKey(String dbName, String table) {
        return dbName + ":" + table;
    }
}

