/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.configuration;

import javax.sql.DataSource;
import org.dragonli.tools.configuration.ConfigurationUtilBase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.stereotype.Component;

@Component
public class DataSourceConfigurationUtil
extends ConfigurationUtilBase {
    @Value(value="${data-source-type-suffix:type}")
    protected String typeSuffix;
    @Value(value="${data-source-config-suffix:data-config}")
    protected String configSuffix;

    public DataSource getDataSource(String prefix) {
        String type = this.configurableEnvironment.getProperty(prefix + "." + this.typeSuffix, "com.zaxxer.hikari.HikariDataSource");
        String key = prefix + "." + this.configSuffix;
        return this.getDataSource(type, key);
    }

    public DataSource getDataSource(String type, String dataSourceConfigPath) {
        try {
            if (type == null || "".equals(type = type.trim())) {
                type = "com.zaxxer.hikari.HikariDataSource";
            }
            Class<?> clazz = Class.forName(type);
            DataSource dataSource = DataSourceBuilder.create().type(clazz).build();
            BindResult result = this.binder.bind(dataSourceConfigPath, Bindable.ofInstance((Object)dataSource));
            return (DataSource)result.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)e);
            return null;
        }
    }
}

