/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.general;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.dragonli.tools.general.IDataCachePool;

public class DataCachePool {
    protected static final Logger logger = Logger.getLogger(DataCachePool.class);
    protected static final ConcurrentMap<Class<?>, Queue<?>> dic = new ConcurrentHashMap();
    protected static final ConcurrentMap<Object, Boolean> allElements = new ConcurrentHashMap<Object, Boolean>();

    public static <T> T get(Class<? extends T> clazz) throws Exception {
        Queue<T> r = DataCachePool.createQueue(clazz);
        T t = r.poll();
        if (t == null) {
            t = clazz.newInstance();
        }
        allElements.remove(t);
        return t;
    }

    private static <T> Queue<T> createQueue(Class<? extends T> clazz) {
        Queue r = (Queue)dic.get(clazz);
        if (r == null) {
            dic.putIfAbsent(clazz, new ConcurrentLinkedQueue());
            r = (Queue)dic.get(clazz);
        }
        return r;
    }

    public static <T> void back(T t) {
        DataCachePool.back(t, "");
    }

    public static <T> void back(T t, String log) {
        if (t == null) {
            return;
        }
        if (allElements.containsKey(t)) {
            logger.warn((Object)(" same object cant be backed again! it will be refused! ClassName:  " + t.getClass()));
            return;
        }
        allElements.put(t, true);
        Queue<?> r = DataCachePool.createQueue(t.getClass());
        if (t instanceof IDataCachePool) {
            ((IDataCachePool)t).clear();
        }
        r.add(t);
    }
}

