/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.mq.rocketmq;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.dragonli.tools.mq.rocketmq.MetaQConsumerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaQEventClient
implements MetaQConsumerClient {
    private static final Logger logger = LoggerFactory.getLogger(MetaQEventClient.class);
    private String instanceName;
    private String consumerGroup;
    private String namesrvAddr;
    private String consumeThreadMax;
    private String consumeThreadMin;
    protected DefaultMQPushConsumer consumer;
    private Map<String, String> subscribeMap = new HashMap<String, String>();
    protected int consumerCorePoolSize = 1;
    protected boolean consumerSuspended = false;
    private MessageListenerConcurrently messageListener;

    @Override
    public void init() throws MQClientException {
        logger.info("creating rocketmq client");
        this.consumer = new DefaultMQPushConsumer(this.consumerGroup);
        this.consumer.setNamesrvAddr(this.namesrvAddr);
        this.consumer.setInstanceName(this.instanceName);
        this.consumer.setConsumerGroup(this.consumerGroup);
        this.consumer.setConsumeThreadMin(Integer.parseInt(this.consumeThreadMin));
        this.consumer.setConsumeThreadMax(Integer.parseInt(this.consumeThreadMax));
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        for (String topic : this.subscribeMap.keySet()) {
            this.consumer.subscribe(topic, this.subscribeMap.get(topic));
        }
        if (this.consumerSuspended) {
            this.consumer.suspend();
        } else {
            this.consumer.resume();
        }
        this.consumer.registerMessageListener(this.messageListener);
        this.consumer.start();
    }

    @Override
    public void shown() {
        this.consumer.shutdown();
    }

    @Override
    public void suspendConsumer() {
        this.consumer.suspend();
    }

    @Override
    public void resumeConsumer() {
        this.consumer.resume();
    }

    @Override
    public void updateConsumerCorePoolSize(int corePoolSize) {
        this.consumer.updateCorePoolSize(corePoolSize);
    }

    @Override
    public MessageExt viewMessage(String msgId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)msgId)) {
            return null;
        }
        return this.consumer.viewMessage(msgId);
    }

    public void setConsumerCorePoolSize(int consumerCorePoolSize) {
        this.consumerCorePoolSize = consumerCorePoolSize;
    }

    public void setConsumerSuspended(boolean consumerSuspended) {
        this.consumerSuspended = consumerSuspended;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public void setConsumeThreadMax(String consumeThreadMax) {
        this.consumeThreadMax = consumeThreadMax;
    }

    public String getConsumeThreadMin() {
        return this.consumeThreadMin;
    }

    public void setConsumeThreadMin(String consumeThreadMin) {
        this.consumeThreadMin = consumeThreadMin;
    }

    public boolean isConsumerSuspended() {
        return this.consumerSuspended;
    }

    public void suspend() {
        if (!this.consumerSuspended) {
            this.consumer.suspend();
            this.consumerSuspended = true;
        }
    }

    public void resume() {
        if (this.consumerSuspended) {
            this.consumer.resume();
            this.consumerSuspended = false;
        }
    }

    public MessageListenerConcurrently getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListenerConcurrently messageListener) {
        this.messageListener = messageListener;
    }

    public void setSubscribeMap(Map<String, String> subscribeMap) {
        this.subscribeMap = subscribeMap;
    }
}

