/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.mq.rocketmq;

import javax.annotation.PreDestroy;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProducer {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final MQProducer producer;

    public MessageProducer(MQProducer producer) {
        this.producer = producer;
    }

    public void sendStringMessage(String groupName, String key, String msg) throws Exception {
        this.doSend(groupName, key, msg.getBytes("UTF-8"), true);
    }

    void doSend(String groupName, String key, byte[] data, boolean delay) throws InterruptedException {
        Message msg = new Message(groupName, key, data);
        if (delay) {
            msg.setDelayTimeLevel(2);
        }
        try {
            SendResult sendResult = this.producer.send(msg);
        }
        catch (MQBrokerException | MQClientException | RemotingException e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public synchronized void close() {
        this.logger.info("shutdown message producer...");
        this.producer.shutdown();
    }
}

