/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.general;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.security.MessageDigest;

public class EncryptionUtil {
    protected static String digestStr(String source, String encode, String type) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(type);
        digest.update(source.getBytes(encode));
        byte[] messageDigest = digest.digest();
        return EncryptionUtil.byteArrayToHexStr(messageDigest);
    }

    public static String sha1(String str) throws Exception {
        return EncryptionUtil.sha1(str, null);
    }

    public static String sha1(String str, Integer len) throws Exception {
        String result = EncryptionUtil.digestStr(str, "UTF-8", "SHA");
        return EncryptionUtil.toShortCryptoCode(result, len);
    }

    public static String md5(String str) throws Exception {
        return EncryptionUtil.md5(str, null);
    }

    public static String md5(String str, Integer len) throws Exception {
        String result = EncryptionUtil.digestStr(str, "UTF-8", "MD5");
        return EncryptionUtil.toShortCryptoCode(result, len);
    }

    public static String byteArrayToHexStr(byte[] arr) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            String shaHex = Integer.toHexString(arr[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexString.append(0);
            }
            hexString.append(shaHex);
        }
        return hexString.toString().toUpperCase();
    }

    public static String toShortCryptoCode(String sourceCode, Integer shortCodeLength) {
        if (shortCodeLength == null || shortCodeLength >= sourceCode.length()) {
            return sourceCode;
        }
        if (shortCodeLength <= 0) {
            return "";
        }
        int bitLen = shortCodeLength << 2;
        BigInteger tailBase = BigInteger.valueOf(-1L << bitLen ^ 0xFFFFFFFFFFFFFFFFL);
        BigInteger bi = new BigInteger(sourceCode, 16);
        long resultNum = 0L;
        while (bi.compareTo(BigInteger.ZERO) != 0) {
            resultNum = bi.and(tailBase).longValue() ^ resultNum;
            bi = bi.shiftRight(bitLen);
        }
        return String.format("%0" + shortCodeLength + "x", resultNum);
    }

    public static String subtraction(String str1, String str2, int scale) throws Exception {
        System.out.println("\u51cf\u6cd5 : " + str1 + " : " + str2 + " : " + scale);
        BigDecimal amount1 = new BigDecimal(str1);
        BigDecimal amount2 = new BigDecimal(str2);
        BigDecimal amount = amount1.subtract(amount2).setScale(scale, 1);
        return EncryptionUtil.toFix(amount.toPlainString());
    }

    public static String multiplication(String str1, String str2, int scale) throws Exception {
        System.out.println("\u4e58\u6cd5 : " + str1 + " : " + str2 + " : " + scale);
        BigDecimal amount1 = new BigDecimal(str1);
        BigDecimal amount2 = new BigDecimal(str2);
        BigDecimal amount = amount1.multiply(amount2).setScale(scale, 1);
        return EncryptionUtil.toFix(amount.toPlainString());
    }

    public static String division(String str1, String str2, int scale) throws Exception {
        System.out.println("\u9664\u6cd5 : " + str1 + " : " + str2 + " : " + scale);
        BigDecimal amount1 = new BigDecimal(str1);
        BigDecimal amount2 = new BigDecimal(str2);
        BigDecimal amount = amount1.divide(amount2, scale, RoundingMode.DOWN);
        return EncryptionUtil.toFix(amount.toPlainString());
    }

    public static String addition(String str1, String str2, int scale) throws Exception {
        System.out.println("\u52a0\u6cd5 : " + str1 + " : " + str2 + " : " + scale);
        BigDecimal amount1 = new BigDecimal(str1);
        BigDecimal amount2 = new BigDecimal(str2);
        BigDecimal amount = amount1.add(amount2).setScale(scale, 1);
        return EncryptionUtil.toFix(amount.toPlainString());
    }

    public static String toFix(String str) {
        int index = 0;
        index = str.indexOf(".");
        str = index < 0 ? str : str.substring(0, index + 2) + str.substring(index + 2).replaceAll("0+$", "");
        return str;
    }
}

