/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.general;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class HttpUtil {
    private static Logger logger = Logger.getLogger(HttpUtil.class);

    public static String[] getUriParts(String uri) {
        String[] uriParts = null;
        try {
            if (StringUtils.isEmpty((String)uri)) {
                return new String[0];
            }
            uriParts = uri.indexOf("?") > 0 ? uri.replaceAll("/", "").split("[?]") : new String[]{uri.replaceAll("/", "").trim()};
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new String[0];
        }
        return uriParts;
    }

    private static String truncateUrlPage(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;
        if ((strURL = strURL.trim().toLowerCase()).length() > 1 && (arrSplit = strURL.split("[?]")).length > 1 && StringUtils.isNotEmpty((String)arrSplit[1])) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }

    public static Map<String, Object> getUrlParams(String url) throws UnsupportedEncodingException {
        int index = url.indexOf("?");
        if (index < 0 || index == url.length() - 1) {
            return new HashMap<String, Object>();
        }
        url = url.substring(index + 1);
        return HttpUtil.getParams(url);
    }

    public static Map<String, Object> getParams(String url) throws UnsupportedEncodingException {
        HashMap<String, Object> mapRequest = new HashMap<String, Object>();
        String[] arrSplit = null;
        if (url == null) {
            return Collections.emptyMap();
        }
        arrSplit = url.split("[&]");
        String[] arrSplitEqual = null;
        for (String strSplit : arrSplit) {
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length <= 1) continue;
            mapRequest.put(URLDecoder.decode(arrSplitEqual[0], "UTF-8"), URLDecoder.decode(arrSplitEqual[1], "UTF-8"));
        }
        return mapRequest;
    }

    public static List<String> getLocalAddressList() {
        ArrayList<String> addrs = new ArrayList<String>(3);
        Enumeration<NetworkInterface> ns = null;
        try {
            ns = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        while (ns != null && ns.hasMoreElements()) {
            NetworkInterface n = ns.nextElement();
            Enumeration<InetAddress> is = n.getInetAddresses();
            while (is.hasMoreElements()) {
                InetAddress i = is.nextElement();
                if (i.isLoopbackAddress() || i.isLinkLocalAddress() || i.isMulticastAddress() || HttpUtil.isSpecialIp(i.getHostAddress())) continue;
                addrs.add(i.getHostAddress());
            }
        }
        return addrs;
    }

    public static String getLocalAddress() {
        List<String> addressList = HttpUtil.getLocalAddressList();
        if (!CollectionUtils.isEmpty(addressList)) {
            return StringUtils.isEmpty((String)addressList.get(0)) ? "" : addressList.get(0).trim();
        }
        return "";
    }

    private static boolean isSpecialIp(String ip) {
        if (ip.contains(":")) {
            return true;
        }
        if (ip.startsWith("127.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        return ip.equals("255.255.255.255");
    }

    public static void main(String[] args) throws UnknownHostException, SocketException {
        System.out.println(HttpUtil.getLocalAddressList());
        System.out.println(HttpUtil.getLocalAddress());
    }
}

