/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.zookeeper;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class ZookeeperClientUtil
implements Watcher {
    private volatile boolean connected = false;
    private volatile long lastConnectTime = 0L;
    private volatile ZooKeeper zk;
    private String servers;
    private int sessionTimeout = 40000000;

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public ZooKeeper getAliveZk() {
        ZooKeeper aliveZk = this.zk;
        if (aliveZk != null && aliveZk.getState().isAlive()) {
            return aliveZk;
        }
        this.zkReconnect();
        return this.zk;
    }

    public synchronized void zkReconnect() {
        this.close();
        try {
            this.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void close() {
        if (this.zk != null) {
            try {
                this.zk.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zk = null;
        }
    }

    private synchronized void connect() throws IOException {
        if (this.zk == null && this.servers != null && !this.servers.trim().equals("")) {
            this.zk = new ZooKeeper(this.servers, this.sessionTimeout, (Watcher)this);
        }
    }

    public String getTextData(String path) throws Exception {
        byte[] data = null;
        if (this.getAliveZk().exists(path, false) == null) {
            return null;
        }
        data = this.getAliveZk().getData(path, false, null);
        return data == null ? null : new String(data, "UTF-8");
    }

    public boolean setTextData(String path, String s) throws Exception {
        return this.setTextData(path, s, null, null);
    }

    public boolean setTextData(String path, String s, List<ACL> ids, CreateMode mode) throws Exception {
        byte[] data = s.getBytes("UTF-8");
        if (this.zk != null && !this.connected) {
            return false;
        }
        if (this.getAliveZk().exists(path, false) != null) {
            this.getAliveZk().setData(path, data, -1);
        } else {
            this.getAliveZk().create(path, data, ids, mode);
        }
        return true;
    }

    public void createIfNotExist(String path, List<ACL> ids) throws Exception {
        String p = "/";
        String[] paths = path.split("/");
        for (int i = 1; i < paths.length; ++i) {
            p = p + paths[i];
            if (this.getAliveZk().exists(p, false) == null) {
                this.getAliveZk().create(p, null, ids, CreateMode.PERSISTENT);
            }
            p = p + "/";
        }
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public void process(WatchedEvent event) {
        System.out.println("event.getState():" + event.getState());
        if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
            this.connected = false;
        } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.connected = true;
            this.lastConnectTime = System.currentTimeMillis();
        } else if (event.getState() == Watcher.Event.KeeperState.Expired) {
            this.zk = null;
            try {
                this.connect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

