/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.tools.general;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JSONUtil {
    private static Logger logger = Logger.getLogger(JSONUtil.class);
    private static JSONObject SUCCESS_JSONOBJECT = JSONUtil.initSuccessJson();
    public static final JSONObject EMPTY_JSONOBJECT = new JSONObject();

    public static <T> List<T> parseList(String content, Class<T> clazz) {
        if (StringUtils.isBlank((String)content)) {
            return Collections.emptyList();
        }
        List results = null;
        try {
            results = JSON.parseArray((String)content, clazz);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return results == null ? Collections.EMPTY_LIST : results;
    }

    public static <T> T parse(String content, Class<T> clazz) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        Object result = null;
        try {
            result = JSON.parseObject((String)content, clazz);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return (T)result;
    }

    public static JSONObject parseObject(String content) {
        if (StringUtils.isBlank((String)content)) {
            return EMPTY_JSONOBJECT;
        }
        JSONObject result = null;
        try {
            result = JSON.parseObject((String)content);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result == null ? EMPTY_JSONOBJECT : result;
    }

    public static String toJSONString(Object object) {
        if (object == null) {
            return EMPTY_JSONOBJECT.toJSONString();
        }
        String result = null;
        try {
            result = JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result == null ? EMPTY_JSONOBJECT.toJSONString() : result;
    }

    private static JSONObject initSuccessJson() {
        JSONObject successJson = new JSONObject();
        successJson.put("code", (Object)0);
        successJson.put("msg", (Object)"");
        return successJson;
    }

    public static JSONObject getSuccessJson() {
        return SUCCESS_JSONOBJECT;
    }

    public static JSONObject getFailuerJson(int code, String msg) {
        JSONObject failureJson = new JSONObject();
        failureJson.put("code", (Object)code);
        failureJson.put("msg", (Object)msg);
        return failureJson;
    }
}

