/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.nettyservice.websockethandle;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dragonli.service.nettyservice.NettyServiceConfig;
import org.dragonli.service.nettyservice.websockethandle.INettySocketCentral;
import org.dragonli.service.nettyservice.websockethandle.INettySocketHandler;
import org.dragonli.service.nettyservice.websockethandle.Tool;

@ChannelHandler.Sharable
public class NettyWebSocketCentral
extends ChannelInboundHandlerAdapter
implements INettySocketCentral {
    public static Logger logger = Logger.getLogger(NettyWebSocketCentral.class);
    private INettySocketHandler handler;
    protected NettyServiceConfig nettyServiceConfig;

    public NettyWebSocketCentral(INettySocketHandler handler) throws Exception {
        if (handler == null) {
            throw new Exception("NettySocketHandler cant be null when u try add web socket service in netty");
        }
        this.handler = handler;
        handler.setCentral(this);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest && Tool.ifWebsocketInitRequest((HttpRequest)((FullHttpRequest)msg))) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketRequest(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void handleWebSocketRequest(ChannelHandlerContext ctx, WebSocketFrame req) {
        logger.info((Object)"socket handleWebSocket.......");
        if (req instanceof CloseWebSocketFrame) {
            logger.info((Object)"socket handleWebSocket : Frame Type-->CloseWebSocketFrame");
            ctx.channel().close();
            return;
        }
        if (req instanceof PongWebSocketFrame) {
            logger.info((Object)"socket handleWebSocket : Frame Type-->PongWebSocketFrame");
            ctx.channel().write((Object)new PongWebSocketFrame(req.content()));
            ctx.channel().closeFuture();
            return;
        }
        if (req instanceof PingWebSocketFrame) {
            logger.info((Object)"socket handleWebSocket : Frame Type-->PingWebSocketFrame");
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(req.content()));
            return;
        }
        if (req instanceof TextWebSocketFrame) {
            String r = this.handler.receive(ctx.channel(), ((TextWebSocketFrame)req).text());
            if (r != null && !"".equals(r)) {
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(r));
            }
            return;
        }
        if (!(req instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(req.getClass().getName() + " frame not supported");
        }
        Channel ch = ctx.channel();
        ch.writeAndFlush((Object)new TextWebSocketFrame("{'a':22}"));
        boolean f = true;
        if (f) {
            return;
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        block3: {
            try {
                if (!this.handler.valicodeSocket((HttpRequest)req)) {
                    return;
                }
                this.handlerWPush(ctx, req);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (!ctx.channel().isActive()) break block3;
                ctx.channel().close();
            }
        }
    }

    private void handlerWPush(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(ctx.pipeline(), (HttpRequest)req), null, false, this.nettyServiceConfig != null ? this.nettyServiceConfig.getMaxFramePayloadLength() : 65536);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            logger.info((Object)("create new websocket ----- maxFramePayloadLength:" + handshaker.maxFramePayloadLength()));
            handshaker.handshake(ctx.channel(), req);
            this.handler.notifyConnected((HttpRequest)req, ctx.channel());
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.warn((Object)("RamoteAddress : " + ctx.channel().remoteAddress() + " active !"));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.handler.notifyClosed(ctx.channel());
    }

    private String getWebSocketLocation(ChannelPipeline cp, HttpRequest req) {
        String protocol = "ws";
        if (cp.get(SslHandler.class) != null) {
            protocol = "wss";
        }
        String path = protocol + "://" + req.headers().get("Host");
        return path;
    }

    @Override
    public void send(Object msg, Map<String, Object> para) {
    }

    @Override
    public void close(Map<String, Object> para) {
    }
}

