/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.nettyservice;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.List;
import org.dragonli.service.nettyservice.NettyServiceConfig;

public class NettyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private List<ChannelHandler> channelHandlers;
    private NettyServiceConfig config;

    public NettyServerInitializer(List<ChannelHandler> channelHandlers, NettyServiceConfig config) {
        this.channelHandlers = channelHandlers;
        this.config = config;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.config.getHttpObjectAggregatorSize())});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        for (ChannelHandler current : this.channelHandlers) {
            pipeline.addLast(new ChannelHandler[]{current});
        }
    }
}

