/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.nettyservice;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dragonli.service.nettyservice.NettyServerInitializer;
import org.dragonli.service.nettyservice.NettyServiceConfig;
import org.dragonli.service.nettyservice.websockethandle.INettySocketHandler;
import org.dragonli.service.nettyservice.websockethandle.NettyWebSocketCentral;

public class NettyService
extends Thread {
    public static final Logger logger = Logger.getLogger(NettyService.class);
    protected NettyServiceConfig config;
    public List<ChannelHandler> channelHandlers;

    public NettyService() throws Exception {
    }

    public NettyService(NettyServiceConfig config) throws Exception {
        this.init(config);
    }

    public void init(NettyServiceConfig config) throws Exception {
        if (config == null) {
            throw new Exception("netty service config cant ba null!");
        }
        this.config = config;
        this.channelHandlers = new ArrayList<ChannelHandler>();
        if (config.isUseWebSocketService()) {
            this.channelHandlers.add((ChannelHandler)this.createNettyWebSocketCentral(config.getSocketHandler()));
        }
        this.start();
    }

    protected NettyWebSocketCentral createNettyWebSocketCentral(INettySocketHandler handler) throws Exception {
        return new NettyWebSocketCentral(this.config.getSocketHandler());
    }

    @Override
    public void run() {
        this.initNettyServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initNettyServer() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workderGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap pushServer = new ServerBootstrap();
            ((ServerBootstrap)pushServer.group((EventLoopGroup)bossGroup, (EventLoopGroup)workderGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new NettyServerInitializer(this.channelHandlers, this.config));
            Channel channel = pushServer.bind(this.config.getNettyPort()).sync().channel();
            logger.info((Object)("===init initWebSocketServer success : " + this.config.getNettyPort() + "==="));
            channel.closeFuture().sync();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workderGroup.shutdownGracefully();
        }
    }
}

