/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.nettyservice;

import java.util.Map;
import org.dragonli.service.nettyservice.websockethandle.INettySocketHandler;

public class NettyServiceConfig {
    private int nettyPort = 8090;
    private int httpObjectAggregatorSize = 65536;
    private int maxFramePayloadLength = 65536;
    private boolean useWebSocketService;
    private Map<String, String> httpHandlers;
    private INettySocketHandler socketHandler;
    private boolean useHttpService;

    public NettyServiceConfig(int port, INettySocketHandler handler) {
        this.nettyPort = port;
        this.socketHandler = handler;
        this.useWebSocketService = this.socketHandler != null;
    }

    public INettySocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    public void setSocketHandler(INettySocketHandler socketHandler) {
        this.socketHandler = socketHandler;
        this.useWebSocketService = socketHandler != null;
    }

    public Map<String, String> getHttpHandlers() {
        return this.httpHandlers;
    }

    public void setHttpHandlers(Map<String, String> httpHandlers) {
        this.httpHandlers = httpHandlers;
        this.useHttpService = httpHandlers != null && httpHandlers.size() != 0;
    }

    public int getHttpObjectAggregatorSize() {
        return this.httpObjectAggregatorSize;
    }

    public void setHttpObjectAggregatorSize(int httpObjectAggregatorSize) {
        this.httpObjectAggregatorSize = httpObjectAggregatorSize;
    }

    public boolean isUseWebSocketService() {
        return this.useWebSocketService;
    }

    public void setUseWebSocketService(boolean useWebSocketService) {
        this.useWebSocketService = useWebSocketService;
    }

    public boolean isUseHttpService() {
        return this.useHttpService;
    }

    public void setUseHttpService(boolean useHttpService) {
        this.useHttpService = useHttpService;
    }

    public int getNettyPort() {
        return this.nettyPort;
    }

    public void setNettyPort(int nettyPort) {
        this.nettyPort = nettyPort;
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public void setMaxFramePayloadLength(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }
}

