/*
 * Decompiled with CFR 0.152.
 */
package org.dragonli.service.modules.userservice.jpaconfig;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.dragonli.tools.configuration.DataSourceConfigurationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class UserJpaConfig {
    public static final String DATASOURCE_USER = "DATASOURCE_USER";
    public static final String ENTITY_MANAGER_USER = "ENTITY_MANAGER_USER";
    public static final String ENTITY_MANAGER_FACTORY_USER = "ENTITY_MANAGER_FACTORY_USER";
    public static final String TRANSACTION_MANAGER_USER = "TRANSACTION_MANAGER_USER";
    @Autowired
    @Qualifier(value="DATASOURCE_USER")
    private DataSource dataSource;

    @Primary
    @ConditionalOnProperty(value={"DS_USER_IS_PRIMARY"})
    @Bean
    DataSource primaryDatasource(@Autowired @Qualifier(value="DATASOURCE_USER") DataSource ds) {
        return ds;
    }

    @Primary
    @ConditionalOnProperty(value={"DS_USER_IS_PRIMARY"})
    @Bean
    public EntityManager primaryEntityManage(@Autowired @Qualifier(value="ENTITY_MANAGER_USER") EntityManager em) {
        return em;
    }

    @Primary
    @ConditionalOnProperty(value={"DS_USER_IS_PRIMARY"})
    @Bean
    public PlatformTransactionManager primaryTransactionManagerBar(@Autowired @Qualifier(value="TRANSACTION_MANAGER_USER") PlatformTransactionManager pm) {
        return pm;
    }

    @Bean(name={"DATASOURCE_USER"})
    DataSource createAssetsDataSource(@Autowired DataSourceConfigurationUtil dataSourceConfigurationUtil, @Value(value="${USER_DATA_SOURCE_CONFIG_LOCAL}") String pathLocal, @Value(value="${USER_DATA_SOURCE_CONFIG}") String path) {
        if (null != pathLocal && !"".equals(pathLocal = pathLocal.trim())) {
            path = pathLocal;
        }
        return dataSourceConfigurationUtil.getDataSource(path);
    }

    @Bean(name={"ENTITY_MANAGER_USER"})
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return this.entityManagerFactory(builder).getObject().createEntityManager();
    }

    @Bean(name={"ENTITY_MANAGER_FACTORY_USER"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder builder) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hibernate.hbm2ddl.auto", "none");
        properties.put("hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
        properties.put("hibernate.show-sql", false);
        properties.put("hibernate.format_sql", false);
        properties.put("hibernate.naming.physical-strategy", "org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl");
        return builder.dataSource(this.dataSource).packages(new String[]{"org.dragonli.service.modules.userservice.entity.models"}).properties(properties).build();
    }

    @Bean(name={"TRANSACTION_MANAGER_USER"})
    public PlatformTransactionManager transactionManagerBar(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(this.entityManagerFactory(builder).getObject());
    }
}

