package org.dreamcat.common.x.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;

/**
 * @author Jerry Will
 * @version 2021/6/7
 */
public final class JavassistUtil {

    private JavassistUtil() {
    }

    public static Set<String> getDependencies(ClassFile cf) {
        ConstPool constPool = cf.getConstPool();
        int size = constPool.getSize();

        Set<String> dependencies = new HashSet<>();
        for (int i = 1; i < size; i++) {
            int tag = constPool.getTag(i);
            if (tag == ConstPool.CONST_Class) {
                String classInfo = constPool.getClassInfo(i);
                dependencies.add(classInfo);
            } else if (tag == ConstPool.CONST_NameAndType) {
                int descriptorIndex = constPool.getNameAndTypeDescriptor(i);
                String info = constPool.getUtf8Info(descriptorIndex);
                for (int k = 0, length = info.length(); k < length; k++) {
                    if (info.charAt(k) == 'L') {
                        String objectInfo = info.substring(++k, k = info.indexOf(';', k));
                        dependencies.add(objectInfo.replace('/', '.'));
                    }
                }
            }
        }
        return dependencies;
    }

    public static Set<String> getDependencies(Class<?> clazz) throws NotFoundException {
        ClassFile cf = CtClassUtil.toCtClass(clazz).getClassFile();
        return getDependencies(cf);
    }

    public static Set<String> getDependencies(InputStream in) throws IOException {
        ClassFile cf = new ClassFile(new DataInputStream(in));
        return getDependencies(cf);
    }
}
