package org.dreamcat.common.x.asm;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.FieldInfo;

/**
 * Create by tuke on 2021/2/15
 */
public class MakeField extends MakeMember<MakeField> {

    final CtField cf;
    final FieldInfo fieldInfo;

    public MakeField(String src, MakeClass makeClass) throws CannotCompileException {
        this(src, makeClass.toCtClass());
    }

    public MakeField(String src, CtClass cc) throws CannotCompileException {
        this(CtField.make(src, cc), cc);
    }

    MakeField(CtField cf, CtClass cc) {
        super(cc);
        this.cf = cf;
        this.fieldInfo = cf.getFieldInfo();
    }

    /**
     * make a field
     *
     * @param src       source code like `public int k = 3;`
     * @param makeClass the class to which the created field is added.
     * @return this object
     * @throws CannotCompileException source code is invalid
     */
    public static MakeField make(String src, MakeClass makeClass) throws CannotCompileException {
        return new MakeField(src, makeClass);
    }

    public static MakeField make(String src, CtClass cc) throws CannotCompileException {
        return new MakeField(src, cc);
    }

    public CtField toCtField() {
        return cf;
    }

    public MakeProperty toMakeProperty() {
        return new MakeProperty(cf, cc);
    }

    @Override
    void addAttribute(AttributeInfo info) {
        fieldInfo.addAttribute(info);
    }

    @Override
    MakeField getThis() {
        return this;
    }

}
