package org.dreamcat.common.x.asm;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.dreamcat.common.util.StringUtil;

/**
 * Create by tuke on 2021/2/15
 */
public class MakeProperty extends MakeField {

    final String fieldName;
    String getterSource;
    String setterSource;
    // transient
    CtClass fieldType;

    /**
     * use {@link MakeField#toMakeProperty()} to new instance
     *
     * @param cf javassist field
     * @param cc javassist class
     */
    MakeProperty(CtField cf, CtClass cc) {
        super(cf, cc);
        this.fieldName = fieldInfo.getName();
    }

    @Override
    void afterAdd() throws CannotCompileException {
        if (getterSource != null) {
            CtMethod getter = CtMethod.make(getterSource, cc);
            cc.addMethod(getter);
        }
        if (setterSource != null) {
            CtMethod setter = CtMethod.make(setterSource, cc);
            cc.addMethod(setter);
        }
    }

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    public MakeProperty makeGetter() throws NotFoundException {
        String literalType = getFieldType().getName();
        String prefix = "boolean".equals(literalType) ? "is" : "get";
        return makeGetter(prefix);
    }

    public MakeProperty makeGetter(String prefix) throws NotFoundException {
        String literalType = getFieldType().getName();
        String capitalFieldName = StringUtil.toCapitalCase(fieldName);
        // source code of the getter
        this.getterSource = String.format("public %s %s%s(){ return this.%s; }",
                literalType, prefix, capitalFieldName, fieldName);
        return this;
    }

    public MakeProperty makeSetter() throws NotFoundException {
        String literalType = getFieldType().getName();
        String capitalFieldName = StringUtil.toCapitalCase(fieldName);

        this.setterSource = String.format("public void set%s(%s value){ this.%s = value; }",
                capitalFieldName, literalType, fieldName);
        return this;
    }

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    private synchronized CtClass getFieldType() throws NotFoundException {
        if (fieldType == null) {
            fieldType = cf.getType();
        }
        return fieldType;
    }
}
