package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * {@link List<String>} or {@link String} to {@link List<String>}
 *
 * @author Jerry Will
 * @version 2021-08-20
 */
public class CommaJoinedStringDeserializer extends JsonDeserializer<List<String>> {

    // @JsonDeserialize(using = CommaJoinedStringDeserializer.class)
    // private List<String> x;
    @Override
    public List<String> deserialize(JsonParser p, DeserializationContext ctxt)
            throws IOException, JsonProcessingException {
        JsonNode node = p.readValueAsTree();
        if (node.isArray()) {
            ArrayNode a = (ArrayNode) node;
            List<String> list = new ArrayList<>(a.size());
            for (JsonNode e : a) {
                list.add(e.asText());
            }
            return list;
        }
        String s = node.asText();
        return new ArrayList<>(Arrays.asList(s.split(",")));
    }
}
