package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

/**
 * {@link String} to Bean
 *
 * @author Jerry Will
 * @version 2021-08-20
 */
@NoArgsConstructor
@AllArgsConstructor
public class JsonStringDeserializer extends JsonDeserializer<Object>
        implements ContextualDeserializer {

    private Class<?> type;

    // @JsonDeserialize(using = JsonStringDeserializer.class)
    // private Bean x;
    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String s = p.getValueAsString();
        return JacksonUtil.fromJson(s, type);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        if (property == null) return this;
        Class<?> rawClass = property.getType().getRawClass();
        return new JsonStringDeserializer(rawClass);
    }
}
