package org.dreamcat.common.x.asm;

import java.util.Collections;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;

/**
 * Create by tuke on 2021/2/15
 */
abstract class MakeMember<T extends MakeMember<T>> {

    final CtClass cc;

    MakeMember(CtClass cc) {
        this.cc = cc;
    }

    abstract void addAttribute(AttributeInfo info);

    abstract T getThis();

    void afterAdd() throws CannotCompileException {

    }

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    public T annotation(String annotationClassName,
            String annotationMethod, String annotationMethodValue) {
        return annotation(annotationClassName, Collections.singletonMap(
                annotationMethod, annotationMethodValue));
    }

    public T annotation(String annotationClassName,
            Map<String, Object> annotationMembers) {
        return annotations(Collections.singletonMap(annotationClassName, annotationMembers));
    }

    public T annotations(Map<String, Map<String, Object>> annotations) {
        return annotations(CtClassUtil.createAnnotationsAttribute(cc, annotations));
    }

    public T annotations(AnnotationsAttribute annotationsAttribute) {
        addAttribute(annotationsAttribute);
        return getThis();
    }
}
