package org.dreamcat.common.x.asm;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.MethodInfo;

/**
 * Create by tuke on 2021/2/15
 */
public class MakeMethod extends MakeMember<MakeMethod> {

    final CtMethod cm;
    final MethodInfo methodInfo;

    public MakeMethod(String src, MakeClass makeClass) throws CannotCompileException {
        this(src, makeClass.toCtClass());
    }

    public MakeMethod(String src, CtClass cc) throws CannotCompileException {
        super(cc);
        this.cm = CtMethod.make(src, cc);
        this.methodInfo = cm.getMethodInfo();
    }

    public static MakeMethod make(String src, MakeClass makeClass) throws CannotCompileException {
        return new MakeMethod(src, makeClass);
    }

    public static MakeMethod make(String src, CtClass cc) throws CannotCompileException {
        return new MakeMethod(src, cc);
    }

    public CtMethod toCtMethod() {
        return cm;
    }

    @Override
    void addAttribute(AttributeInfo info) {
        methodInfo.addAttribute(info);
    }

    @Override
    MakeMethod getThis() {
        return this;
    }
}
