package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

/**
 * Bean to {@link String}
 *
 * @author Jerry Will
 * @version 2021-08-20
 */
public class JsonStringSerializer extends JsonSerializer<Object> {

    // @JsonSerialize(using = JsonStringSerializer.class)
    // private Bean x;
    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(JsonUtil.toJson(value));
    }
}
