package org.dreamcat.common.x.plot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dreamcat.common.io.FileUtil;
import org.dreamcat.common.io.ShellUtil;
import org.dreamcat.common.text.DollarInterpolation;

/**
 * @author Jerry Will
 * @version 2021-07-31
 */
@SuppressWarnings({"unchecked"})
public class PlotMap {

    public final Map<String, Object> _value = new HashMap<>();
    private Map<String, String> context;
    private String html;
    private String htmlFile;

    protected Map<String, Object> map(String name) {
        return (Map<String, Object>) _value.computeIfAbsent(name, it -> new HashMap<>());
    }

    protected List<Map<String, Object>> listMap(String name) {
        return (List<Map<String, Object>>) _value.computeIfAbsent(name, it -> new ArrayList<>());
    }

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    protected Map<String, String> getContext() {
        throw new UnsupportedOperationException();
    }

    protected String getTemplate() {
        throw new UnsupportedOperationException();
    }

    public PlotMap saveHtml() throws IOException {
        String file = File.createTempFile(getClass().getPackage().getName(), ".html").getAbsolutePath();
        return saveHtml(file);
    }

    public PlotMap saveHtml(String htmlFile) throws IOException {
        this.htmlFile = htmlFile;

        if (context == null) {
            context = getContext();
        }
        if (html == null) {
            html = DollarInterpolation.format(getTemplate(), context);
        }
        FileUtil.writeFrom(htmlFile, html);
        return this;
    }

    public PlotMap open() {
        try {
            if (htmlFile == null) {
                saveHtml();
            }
            ShellUtil.exec("open file:" + htmlFile);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}
