package org.dreamcat.common.x.plot.echart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.echart.enums.ECAxisType;
import org.dreamcat.common.x.plot.echart.enums.ECLocation;

/**
 * @author Jerry Will
 * @version 2021-07-31
 */
public class ECAxis extends PlotMap {

    public ECAxis gridIndex(int gridIndex) {
        _value.put("gridIndex", gridIndex);
        return this;
    }

    public ECAxis type(ECAxisType type) {
        _value.put("type", type.toString());
        return this;
    }

    public ECAxis name(String name) {
        _value.put("name", name);
        return this;
    }

    public ECAxis nameLocation(ECLocation nameLocation) {
        _value.put("nameLocation", nameLocation.toString());
        return this;
    }

    public ECAxis nameTextStyle(ECTextStyle nameTextStyle) {
        _value.put("nameTextStyle", nameTextStyle);
        return this;
    }

    public ECAxis inverse(boolean inverse) {
        _value.put("inverse", inverse);
        return this;
    }

    public ECAxis data(Object... data) {
        return data(Arrays.asList((Object[]) data));
    }

    public ECAxis data(List<Object> data) {
        List<Object> list = new ArrayList<>();
        for (Object i : data) {
            if (i instanceof ECAxisValue) {
                list.add(((ECAxisValue) i)._value);
            } else if (i instanceof Number) {
                list.add(i);
            } else {
                list.add(Objects.toString(i));
            }
        }
        _value.put("data", list);
        return this;
    }

    public ECAxis boundaryGap(boolean boundaryGap) {
        _value.put("boundaryGap", boundaryGap);
        return this;
    }
}
