package org.dreamcat.common.x.plot.echart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.echart.enums.ECAlign;
import org.dreamcat.common.x.plot.echart.enums.ECOrient;
import org.dreamcat.common.x.plot.echart.enums.ECVerticalAlign;

/**
 * @author Jerry Will
 * @version 2021-07-31
 */
public class ECLegend extends PlotMap {

    public ECLegend textStyle(ECTextStyle textStyle) {
        _value.put("textStyle", textStyle);
        return this;
    }

    public ECLegend data(String... data) {
        return data(Arrays.asList((Object[]) data));
    }

    public ECLegend data(List<Object> data) {
        List<Object> list = new ArrayList<>();
        for (Object i : data) {
            if (i instanceof ECAxisValue) {
                list.add(((ECAxisValue) i)._value);
            } else {
                list.add(Objects.toString(i));
            }
        }
        _value.put("data", list);
        return this;
    }

    public ECLegend orient(ECOrient orient) {
        _value.put("orient", orient.toString());
        return this;
    }

    public ECLegend left(ECAlign left) {
        _value.put("left", left.toString());
        return this;
    }

    public ECLegend left(String left) {
        _value.put("left", left);
        return this;
    }

    public ECLegend left(int left) {
        _value.put("left", left);
        return this;
    }

    public ECLegend right(ECAlign right) {
        _value.put("right", right.toString());
        return this;
    }

    public ECLegend right(String right) {
        _value.put("right", right);
        return this;
    }

    public ECLegend right(int right) {
        _value.put("right", right);
        return this;
    }

    public ECLegend top(ECVerticalAlign top) {
        _value.put("top", top.toString());
        return this;
    }

    public ECLegend top(String top) {
        _value.put("top", top);
        return this;
    }

    public ECLegend top(int top) {
        _value.put("top", top);
        return this;
    }

    public ECLegend bottom(ECVerticalAlign bottom) {
        _value.put("bottom", bottom.toString());
        return this;
    }

    public ECLegend bottom(String bottom) {
        _value.put("bottom", bottom);
        return this;
    }

    public ECLegend bottom(int bottom) {
        _value.put("bottom", bottom);
        return this;
    }
}
