package org.dreamcat.common.x.plot.echart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.echart.enums.ECSeriesType;

/**
 * @author Jerry Will
 * @version 2021-07-31
 */
@SuppressWarnings({"unchecked"})
public class ECSeries extends PlotMap {

    public ECSeries type(ECSeriesType type) {
        _value.put("type", type.toString());
        return this;
    }

    public ECSeries name(String name) {
        _value.put("name", name);
        return this;
    }

    public ECSeries stack(String stack) {
        _value.put("stack", stack);
        return this;
    }

    public ECSeries data(Object... data) {
        return data(Arrays.asList(data));
    }

    public ECSeries data(List<Object> data) {
        _value.put("data", dataTo(data));
        return this;
    }

    private static List<Object> dataTo(List<Object> data) {
        List<Object> list = new ArrayList<>();
        for (Object i : data) {
            if (i instanceof ECSeriesValue) {
                list.add(((ECSeriesValue) i)._value);
            } else if (i instanceof Number) {
                list.add(i);
            } else if (i instanceof List) {
                list.add(dataTo((List<Object>) i));
            } else {
                list.add(Objects.toString(i));
            }
        }
        return list;
    }

    public ECSeries smooth() {
        return smooth(true);
    }

    public ECSeries smooth(boolean smooth) {
        _value.put("smooth", smooth);
        return this;
    }

    public ECSeries areaStyle(ECAreaStyle areaStyle) {
        _value.put("areaStyle", areaStyle);
        return this;
    }

}
