package org.dreamcat.common.x.plot.echart;

import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.echart.enums.ECFontStyle;
import org.dreamcat.common.x.plot.echart.enums.ECFontWeight;
import org.dreamcat.common.x.plot.echart.enums.ECOverflow;

/**
 * @author Jerry Will
 * @version 2021-07-30
 */
public class ECTextStyle extends PlotMap {

    public ECTextStyle textAlign(String color) {
        _value.put("color", color);
        return this;
    }

    public ECTextStyle fontStyle(ECFontStyle fontStyle) {
        _value.put("fontStyle", fontStyle.toString());
        return this;
    }

    public ECTextStyle fontWeight(int fontWeight) {
        _value.put("fontWeight", fontWeight);
        return this;
    }

    public ECTextStyle fontWeight(ECFontWeight fontWeight) {
        _value.put("fontWeight", fontWeight.toString());
        return this;
    }

    public ECTextStyle fontFamily(String fontFamily) {
        _value.put("fontFamily", fontFamily);
        return this;
    }

    public ECTextStyle fontSize(int fontSize) {
        _value.put("fontSize", fontSize);
        return this;
    }

    public ECTextStyle lineHeight(int lineHeight) {
        _value.put("lineHeight", lineHeight);
        return this;
    }

    public ECTextStyle width(int width) {
        _value.put("width", width);
        return this;
    }

    public ECTextStyle height(int height) {
        _value.put("height", height);
        return this;
    }

    public ECTextStyle overflow(ECOverflow overflow) {
        _value.put("overflow", overflow.toString());
        return this;
    }

    public ECTextStyle ellipsis(String ellipsis) {
        _value.put("ellipsis", ellipsis);
        return this;
    }
}
