package org.dreamcat.common.x.plot.echart;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import java.util.Arrays;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.echart.enums.ECAlign;
import org.dreamcat.common.x.plot.echart.enums.ECLinkTarget;
import org.dreamcat.common.x.plot.echart.enums.ECVerticalAlign;

/**
 * @author Jerry Will
 * @version 2021-07-30
 */
@JsonInclude(Include.NON_EMPTY)
public class ECTitle extends PlotMap {

    public ECTitle text(String text) {
        _value.put("text", text);
        return this;
    }

    public ECTitle link(String link) {
        _value.put("link", link);
        return this;
    }

    public ECTitle target(ECLinkTarget target) {
        _value.put("target", target.toString());
        return this;
    }

    public ECTitle textStyle(ECTextStyle textStyle) {
        _value.put("textStyle", textStyle._value);
        return this;
    }

    public ECTitle subtext(String text) {
        _value.put("subtext", text);
        return this;
    }

    public ECTitle sublink(String link) {
        _value.put("sublink", link);
        return this;
    }

    public ECTitle subtarget(ECLinkTarget target) {
        _value.put("subtarget", target.toString());
        return this;
    }

    public ECTitle subTextStyle(ECTextStyle textStyle) {
        _value.put("subTextStyle", textStyle._value);
        return this;
    }

    public ECTitle textAlign(ECAlign textAlign) {
        _value.put("textAlign", textAlign.toString());
        return this;
    }

    public ECTitle textVerticalAlign(ECVerticalAlign textVerticalAlign) {
        _value.put("textVerticalAlign", textVerticalAlign.toString());
        return this;
    }

    public ECTitle padding(int padding) {
        _value.put("padding", padding);
        return this;
    }

    public ECTitle padding(int topBottom, int leftRight) {
        _value.put("padding", Arrays.asList(topBottom, leftRight));
        return this;
    }

    public ECTitle padding(int top, int right, int bottom, int left) {
        _value.put("padding", Arrays.asList(top, right, bottom, left));
        return this;
    }
}
