package org.dreamcat.common.x.plot.echart;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dreamcat.common.util.MapUtil;
import org.dreamcat.common.x.jackson.JsonUtil;
import org.dreamcat.common.x.plot.PlotMap;

/**
 * @author Jerry Will
 * @version 2021-07-30
 */
public class ECharts extends PlotMap {

    public ECharts title(Map<String, Object> title) {
        MapUtil.merge(map("title"), title);
        return this;
    }

    public ECharts title(ECTitle title) {
        return title(title._value);
    }

    public ECharts tooltip(Map<String, Object> tooltip) {
        MapUtil.merge(map("tooltip"), tooltip);
        return this;
    }

    public ECharts tooltip(ECTooltip tooltip) {
        return tooltip(tooltip._value);
    }

    public ECharts legend(Map<String, Object> legend) {
        MapUtil.merge(map("legend"), legend);
        return this;
    }

    public ECharts legend(ECLegend legend) {
        return legend(legend._value);
    }

    public ECharts xAxis(Map<String, Object> xAxis) {
        MapUtil.merge(map("xAxis"), xAxis);
        return this;
    }

    public ECharts xAxis(ECAxis xAxis) {
        return xAxis(xAxis._value);
    }

    public ECharts yAxis(Map<String, Object> yAxis) {
        MapUtil.merge(map("yAxis"), yAxis);
        return this;
    }

    public ECharts yAxis(ECAxis yAxis) {
        return yAxis(yAxis._value);
    }

    public ECharts seriesRaw(List<Map<String, Object>> series) {
        _value.put("series", series);
        return this;
    }

    public ECharts series(ECSeries... series) {
        return series(Arrays.asList(series));
    }

    public ECharts series(List<ECSeries> series) {
        return seriesRaw(series.stream().map(it -> it._value).collect(Collectors.toList()));
    }

    @Override
    protected Map<String, String> getContext() {
        String option = JsonUtil.toJson(_value);
        return MapUtil.of("option", option);
    }

    @Override
    protected String getTemplate() {
        return TEMPLATE;
    }

    private static final String TEMPLATE = "<!DOCTYPE html><html style=\"height: 100%\" lang=\"en\"> <head> <meta charset=\"utf-8\"> </head> <body style=\"height: 100%; margin: 0\"> <div id=\"container\" style=\"height: 100%\"></div> <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/echarts@5/dist/echarts.min.js\"></script> <script type=\"text/javascript\">var dom = document.getElementById(\"container\");var myChart = echarts.init(dom);var option = $option;if (option && typeof option === 'object') { myChart.setOption(option);} </script> </body></html>";

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    public static ECharts echarts() {
        return new ECharts();
    }

    public static ECAxis xAxis() {
        return new ECAxis();
    }

    public static ECAxis yAxis() {
        return new ECAxis();
    }

    public static ECAxisValue axisValue() {
        return new ECAxisValue();
    }

    public static ECSeries series() {
        return new ECSeries();
    }

    public static ECSeriesValue seriesValue() {
        return new ECSeriesValue();
    }

    public static ECAreaStyle areaStyle() {
        return new ECAreaStyle();
    }

    public static ECTooltip tooltip() {
        return new ECTooltip();
    }

    public static ECLegend legend() {
        return new ECLegend();
    }

    public static ECLegendValue legendValue() {
        return new ECLegendValue();
    }
}
