package org.dreamcat.common.x.plot.plotly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dreamcat.common.util.MapUtil;
import org.dreamcat.common.x.jackson.JsonUtil;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.plotly.enums.PlotlyDataMode;

/**
 * @author Jerry Will
 * @version 2021-07-31
 */
public class Plotly extends PlotMap {

    public Plotly addData(PlotlyData data) {
        try {
            listMap("data").add(data._value);
        } catch (UnsupportedOperationException ignore) {
            List<Map<String, Object>> mutable = new ArrayList<>(listMap("data"));
            mutable.add(data._value);
            _value.put("data", mutable);
        }
        return this;
    }

    public Plotly data(PlotlyData... data) {
        return data(Arrays.asList(data));
    }

    public Plotly data(List<PlotlyData> data) {
        return dataRaw(data.stream().map(it -> it._value).collect(Collectors.toList()));
    }

    public Plotly dataRaw(List<Map<String, Object>> data) {
        _value.put("data", data);
        return this;
    }

    public Plotly layout(PlotlyLayout layout) {
        return layout(layout._value);
    }

    public Plotly layout(Map<String, Object> layout) {
        MapUtil.merge(map("layout"), layout);
        return this;
    }

    @Override
    protected Map<String, String> getContext() {
        String data = JsonUtil.toJson(listMap("data"));
        String layout = JsonUtil.toJson(map("layout"));
        return MapUtil.of("data", data, "layout", layout);
    }

    @Override
    protected String getTemplate() {
        return TEMPLATE;
    }

    private static final String TEMPLATE = "<!DOCTYPE html><html lang=\"en\"><head> <meta charset=\"utf-8\"></head><body><div id='container'></div><script type=\"text/javascript\" src='https://cdn.jsdelivr.net/npm/plotly.js@2.3.1/dist/plotly.min.js'></script><script type=\"text/javascript\"> Plotly.newPlot('container', $data, $layout);</script></body></html>";

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    public static Plotly plotly() {
        return new Plotly();
    }

    public static PlotlyData plotlyData() {
        return new PlotlyData();
    }

    public static PlotlyLayout plotlyLayout() {
        return new PlotlyLayout();
    }

    public static PlotlyAxis plotlyAxis() {
        return new PlotlyAxis();
    }

    public static PlotlyLine plotlyLine() {
        return new PlotlyLine();
    }

    public static PlotlyMarker plotlyMarker() {
        return new PlotlyMarker();
    }

    // ==== ==== ==== ====    ==== ==== ==== ====    ==== ==== ==== ====

    public static <T> void plotStack(List<?> x,
            List<long[]> tss, Function<Long, T> mapper, String... stack) throws IOException {
        List<PlotlyData> list = new ArrayList<>();

        for (int i = 0, size = stack.length; i < size; i++) {
            int seq = i;
            List<Object> y = tss.stream().map(ts -> ts[seq])
                    .map(mapper).collect(Collectors.toList());
            list.add(plotlyData()
                    .mode(PlotlyDataMode.lines)
                    .x(x)
                    .y(y)
                    .name(stack[seq]));
        }
        plotly().data(list).layout(plotlyLayout()).saveHtml().open();
    }
}
