package org.dreamcat.common.x.plot.plotly;

import java.util.List;
import java.util.Map;
import org.dreamcat.common.util.MapUtil;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.plotly.enums.PlotlyDataMode;
import org.dreamcat.common.x.plot.plotly.enums.PlotlyDataType;

/**
 * @author Jerry Will
 * @version 2021-07-31
 */
public class PlotlyData extends PlotMap {

    public PlotlyData type(PlotlyDataType type) {
        _value.put("type", type.toString());
        return this;
    }

    public PlotlyData mode(PlotlyDataMode mode) {
        _value.put("mode", mode.toString());
        return this;
    }

    public PlotlyData x(List<?> x) {
        _value.put("x", x);
        return this;
    }

    public PlotlyData y(List<?> y) {
        _value.put("y", y);
        return this;
    }

    public PlotlyData name(String name) {
        _value.put("name", name);
        return this;
    }

    public PlotlyData line(PlotlyLine line) {
        return line(line._value);
    }

    public PlotlyData line(Map<String, Object> line) {
        MapUtil.merge(map("line"), line);
        return this;
    }
}
