/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import org.dreamcat.common.x.asm.CtClassUtil;

public final class JavassistUtil {
    private JavassistUtil() {
    }

    public static Set<String> getDependencies(ClassFile cf) {
        ConstPool constPool = cf.getConstPool();
        int size = constPool.getSize();
        HashSet<String> dependencies = new HashSet<String>();
        for (int i = 1; i < size; ++i) {
            int tag = constPool.getTag(i);
            if (tag == 7) {
                String classInfo = constPool.getClassInfo(i);
                dependencies.add(classInfo);
                continue;
            }
            if (tag != 12) continue;
            int descriptorIndex = constPool.getNameAndTypeDescriptor(i);
            String info = constPool.getUtf8Info(descriptorIndex);
            int length = info.length();
            for (int k = 0; k < length; ++k) {
                if (info.charAt(k) != 'L') continue;
                int n = ++k;
                k = info.indexOf(59, k);
                String objectInfo = info.substring(n, k);
                dependencies.add(objectInfo.replace('/', '.'));
            }
        }
        return dependencies;
    }

    public static Set<String> getDependencies(Class<?> clazz) throws NotFoundException {
        ClassFile cf = CtClassUtil.toCtClass(clazz).getClassFile();
        return JavassistUtil.getDependencies(cf);
    }

    public static Set<String> getDependencies(InputStream in) throws IOException {
        ClassFile cf = new ClassFile(new DataInputStream(in));
        return JavassistUtil.getDependencies(cf);
    }
}

