/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.asm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import org.dreamcat.common.x.asm.CtClassUtil;
import org.dreamcat.common.x.asm.MakeConstructor;
import org.dreamcat.common.x.asm.MakeField;
import org.dreamcat.common.x.asm.MakeMethod;

public class MakeClass {
    private final ClassPool classPool = ClassPool.getDefault();
    private final CtClass cc;
    private final ClassFile classFile;

    public MakeClass(String className) {
        this.cc = this.classPool.makeClass(className);
        this.classFile = this.cc.getClassFile();
    }

    public static MakeClass make(String className) {
        return new MakeClass(className);
    }

    public Class<?> toClass() throws CannotCompileException {
        return this.toCtClass().toClass();
    }

    public CtClass toCtClass() {
        return this.cc;
    }

    public MakeClass superClass(Class<?> superClass) throws NotFoundException, CannotCompileException {
        return this.superClass(this.classPool.get(superClass.getCanonicalName()));
    }

    public MakeClass superClass(MakeClass superClass) throws CannotCompileException {
        return this.superClass(superClass.toCtClass());
    }

    public MakeClass superClass(CtClass superClass) throws CannotCompileException {
        this.cc.setSuperclass(superClass);
        return this;
    }

    public MakeClass interfaces(Collection<Class<?>> interfaces) throws NotFoundException {
        for (Class<?> i : interfaces) {
            this.cc.addInterface(CtClassUtil.toCtClass(i));
        }
        return this;
    }

    public MakeClass interfaceOf(Collection<MakeClass> interfaces) {
        for (MakeClass i : interfaces) {
            this.cc.addInterface(i.toCtClass());
        }
        return this;
    }

    public MakeClass interfaceFrom(Collection<CtClass> interfaces) {
        for (CtClass i : interfaces) {
            this.cc.addInterface(i);
        }
        return this;
    }

    public MakeClass addInterfaces(Class<?> ... interfaces) throws NotFoundException {
        return this.interfaces(Arrays.asList(interfaces));
    }

    public MakeClass addInterfaceOf(MakeClass ... interfaces) {
        return this.interfaceOf(Arrays.asList(interfaces));
    }

    public MakeClass addInterfaceFrom(CtClass ... interfaces) {
        return this.interfaceFrom(Arrays.asList(interfaces));
    }

    public MakeClass annotation(String annotationClassName, String annotationMethod, String annotationMethodValue) {
        return this.annotation(annotationClassName, Collections.singletonMap(annotationMethod, annotationMethodValue));
    }

    public MakeClass annotation(String annotationClassName, Map<String, Object> annotationMembers) {
        return this.annotations(Collections.singletonMap(annotationClassName, annotationMembers));
    }

    public MakeClass annotations(Map<String, Map<String, Object>> annotations) {
        return this.annotations(CtClassUtil.createAnnotationsAttribute(this.classFile.getConstPool(), annotations));
    }

    public MakeClass annotations(AnnotationsAttribute annotationsAttribute) {
        this.classFile.addAttribute((AttributeInfo)annotationsAttribute);
        return this;
    }

    public MakeClass fields(Collection<MakeField> fields) throws CannotCompileException {
        for (MakeField i : fields) {
            this.cc.addField(i.toCtField());
            i.afterAdd();
        }
        return this;
    }

    public MakeClass fieldFrom(Collection<CtField> fields) throws CannotCompileException {
        for (CtField i : fields) {
            this.cc.addField(i);
        }
        return this;
    }

    public MakeClass fields(MakeField ... fields) throws CannotCompileException {
        return this.fields(Arrays.asList(fields));
    }

    public MakeClass fieldFrom(CtField ... fields) throws CannotCompileException {
        return this.fieldFrom(Arrays.asList(fields));
    }

    public MakeClass methods(Collection<MakeMethod> methods) throws CannotCompileException {
        for (MakeMethod i : methods) {
            this.cc.addMethod(i.toCtMethod());
            i.afterAdd();
        }
        return this;
    }

    public MakeClass methodFrom(Collection<CtMethod> methods) throws CannotCompileException {
        for (CtMethod i : methods) {
            this.cc.addMethod(i);
        }
        return this;
    }

    public MakeClass methods(MakeMethod ... methods) throws CannotCompileException {
        return this.methods(Arrays.asList(methods));
    }

    public MakeClass methodFrom(CtMethod ... methods) throws CannotCompileException {
        return this.methodFrom(Arrays.asList(methods));
    }

    public MakeClass constructors(Collection<MakeConstructor> constructors) throws CannotCompileException {
        for (MakeConstructor i : constructors) {
            this.cc.addConstructor(i.toCtConstructor());
            i.afterAdd();
        }
        return this;
    }

    public MakeClass constructorFrom(Collection<CtConstructor> constructors) throws CannotCompileException {
        for (CtConstructor i : constructors) {
            this.cc.addConstructor(i);
        }
        return this;
    }

    public MakeClass constructors(MakeConstructor ... constructors) throws CannotCompileException {
        return this.constructors(Arrays.asList(constructors));
    }

    public MakeClass constructorFrom(CtConstructor ... constructors) throws CannotCompileException {
        return this.constructorFrom(Arrays.asList(constructors));
    }
}

