/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.bean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import org.dreamcat.common.util.ReflectUtil;

public final class BeanCopyUtil {
    private static Map<Class, Map<Class, BeanCopier>> cache = new ConcurrentHashMap<Class, Map<Class, BeanCopier>>();

    private BeanCopyUtil() {
    }

    public static synchronized void evictCache() {
        cache.clear();
        cache = new ConcurrentHashMap<Class, Map<Class, BeanCopier>>();
    }

    public static <S> S copy(S source) {
        if (source == null) {
            return null;
        }
        return (S)BeanCopyUtil.copy(source, source.getClass());
    }

    public static <S, T> T copy(S source, Class<T> targetClass) {
        Object target = ReflectUtil.newInstance(targetClass);
        BeanCopyUtil.copy(source, target);
        return (T)target;
    }

    public static <S, T> void copy(S source, T target) {
        BeanCopyUtil.copy(source, target, true);
    }

    public static <S, T> void copy(S source, T target, boolean useConverter) {
        if (source == null || target == null) {
            return;
        }
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        BeanCopier copier = cache.computeIfAbsent(sourceClass, it -> new ConcurrentHashMap()).computeIfAbsent(targetClass, it -> BeanCopier.create((Class)sourceClass, (Class)targetClass, (boolean)useConverter));
        copier.copy(source, target, BeanCopyUtil::convert);
    }

    private static Object convert(Object sourceFieldValue, Class targetFieldClass, Object targetFieldSetterName) {
        return ReflectUtil.cast((Object)sourceFieldValue, (Class)targetFieldClass);
    }
}

