/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommaJoinedStringDeserializer
extends JsonDeserializer<List<String>> {
    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node.isArray()) {
            ArrayNode a = (ArrayNode)node;
            ArrayList<String> list = new ArrayList<String>(a.size());
            for (JsonNode e : a) {
                list.add(e.asText());
            }
            return list;
        }
        String s = node.asText();
        return new ArrayList<String>(Arrays.asList(s.split(",")));
    }
}

