/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import org.dreamcat.common.x.jackson.JsonUtil;

public class JsonStringDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private Class<?> type;

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String s = p.getValueAsString();
        return JsonUtil.fromJson(s, this.type);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        if (property == null) {
            return this;
        }
        Class rawClass = property.getType().getRawClass();
        return new JsonStringDeserializer(rawClass);
    }

    public JsonStringDeserializer() {
    }

    public JsonStringDeserializer(Class<?> type) {
        this.type = type;
    }
}

