/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static void findAndRegisterModules() {
        JsonUtil.registerModules(ObjectMapper.findModules());
    }

    public static void registerModules(Iterable<? extends Module> modules) {
        objectMapper.registerModules(modules);
    }

    public static <T> Map<String, Object> toMap(T bean) {
        return (Map)objectMapper.convertValue(bean, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static <T> T fromMap(Map<?, ?> map, Class<?> genericClass, Class<?> ... parameterTypes) {
        return (T)objectMapper.convertValue(map, JsonUtil.getGenericType(genericClass, parameterTypes));
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(File file, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(Reader reader, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(reader, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(inputStream, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(String json) {
        return JsonUtil.fromJson(json, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(String json, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(File file) {
        return JsonUtil.fromJson(file, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(File file, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(file, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(Reader reader) {
        return JsonUtil.fromJson(reader, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(Reader reader, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(reader, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <V> Map<String, V> fromJsonObject(InputStream inputStream, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(json, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(File file, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(file, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(Reader reader, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(reader, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(InputStream inputStream, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(inputStream, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String toJson(Object bean) {
        try {
            return objectMapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static byte[] toJsonBytes(Object bean) {
        try {
            return objectMapper.writeValueAsBytes(bean);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static boolean writeJson(Object bean, File file) {
        try {
            objectMapper.writeValue(file, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeJson(Object bean, Writer writer) {
        try {
            objectMapper.writeValue(writer, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeJson(Object bean, OutputStream outputStream) {
        try {
            objectMapper.writeValue(outputStream, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static JsonNode toJsonTree(String json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Integer getInt(String json, String memberName) {
        return JsonUtil.getInt(JsonUtil.toJsonTree(json), memberName);
    }

    public static Integer getInt(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asInt();
        }
        return null;
    }

    public static Long getLong(String json, String memberName) {
        return JsonUtil.getLong(JsonUtil.toJsonTree(json), memberName);
    }

    public static Long getLong(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asLong();
        }
        return null;
    }

    public static Double getDouble(String json, String memberName) {
        return JsonUtil.getDouble(JsonUtil.toJsonTree(json), memberName);
    }

    public static Double getDouble(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asDouble();
        }
        return null;
    }

    public static String getString(String json, String memberName) {
        return JsonUtil.getString(JsonUtil.toJsonTree(json), memberName);
    }

    public static String getString(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asText();
        }
        return null;
    }

    public static Boolean getBoolean(String json, String memberName) {
        return JsonUtil.getBoolean(JsonUtil.toJsonTree(json), memberName);
    }

    public static Boolean getBoolean(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asBoolean();
        }
        return null;
    }

    public static JavaType getGenericType(Class<?> genericClass, Class<?> ... parameterTypes) {
        return objectMapper.getTypeFactory().constructParametricType(genericClass, (Class[])parameterTypes);
    }

    static {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

