/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dreamcat.common.x.jackson.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YamlUtil {
    private static final Logger log = LoggerFactory.getLogger(YamlUtil.class);
    private static final ObjectMapper objectMapper = new YAMLMapper();

    private YamlUtil() {
    }

    public static void findAndRegisterModules() {
        YamlUtil.registerModules(ObjectMapper.findModules());
    }

    public static void registerModules(Iterable<? extends Module> modules) {
        objectMapper.registerModules(modules);
    }

    public static <T> T fromYaml(String yaml, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(yaml, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromYaml(File file, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromYaml(Reader reader, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(reader, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromYaml(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(inputStream, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromYamlObject(String yaml) {
        return YamlUtil.fromYaml(yaml, Map.class);
    }

    public static <V> Map<String, V> fromYamlObject(String yaml, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(yaml, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromYamlObject(File file) {
        return YamlUtil.fromYaml(file, Map.class);
    }

    public static <V> Map<String, V> fromYamlObject(File file, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(file, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromYamlObject(Reader reader) {
        return YamlUtil.fromYaml(reader, Map.class);
    }

    public static <V> Map<String, V> fromYamlObject(Reader reader, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(reader, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <V> Map<String, V> fromYamlObject(InputStream inputStream, Class<V> valueType) {
        try {
            JavaType javaType = JsonUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromYamlArray(String yaml, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(yaml, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromYamlArray(File file, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(file, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromYamlArray(Reader reader, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(reader, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromYamlArray(InputStream inputStream, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(inputStream, JsonUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String toYaml(Object bean) {
        try {
            return objectMapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static byte[] toYamlBytes(Object bean) {
        try {
            return objectMapper.writeValueAsBytes(bean);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static boolean writeYaml(Object bean, File file) {
        try {
            objectMapper.writeValue(file, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeYaml(Object bean, Writer writer) {
        try {
            objectMapper.writeValue(writer, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeYaml(Object bean, OutputStream outputStream) {
        try {
            objectMapper.writeValue(outputStream, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static JsonNode toJsonTree(String yaml) {
        try {
            return objectMapper.readTree(yaml);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Integer getInt(String yaml, String memberName) {
        return YamlUtil.getInt(YamlUtil.toJsonTree(yaml), memberName);
    }

    public static Integer getInt(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asInt();
        }
        return null;
    }

    public static Long getLong(String yaml, String memberName) {
        return YamlUtil.getLong(YamlUtil.toJsonTree(yaml), memberName);
    }

    public static Long getLong(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asLong();
        }
        return null;
    }

    public static Double getDouble(String yaml, String memberName) {
        return YamlUtil.getDouble(YamlUtil.toJsonTree(yaml), memberName);
    }

    public static Double getDouble(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asDouble();
        }
        return null;
    }

    public static String getString(String yaml, String memberName) {
        return YamlUtil.getString(YamlUtil.toJsonTree(yaml), memberName);
    }

    public static String getString(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asText();
        }
        return null;
    }

    public static Boolean getBoolean(String yaml, String memberName) {
        return YamlUtil.getBoolean(YamlUtil.toJsonTree(yaml), memberName);
    }

    public static Boolean getBoolean(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asBoolean();
        }
        return null;
    }

    static {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

