/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dreamcat.common.util.ObjectUtil;

public class MailSender {
    private static final Properties DEFAULT_SMTP_PROPERTIES = new Properties();
    private static final String DEFAULT_BYTES_TYPE = "application/octet-stream";
    private final Properties properties;
    private final String host;
    private final String username;
    private final String password;

    public MailSender(String host, String username, String password) {
        this(new Properties(), host, username, password);
    }

    public MailSender withDefaultSmtpProperties() {
        this.properties.putAll((Map<?, ?>)DEFAULT_SMTP_PROPERTIES);
        return this;
    }

    public MailSender debug() {
        return this.debug(true);
    }

    public MailSender debug(boolean debug) {
        this.properties.put("mail.debug", debug ? "true" : "false");
        return this;
    }

    public Op newOp() {
        return new Op(this);
    }

    public MailSender(Properties properties, String host, String username, String password) {
        this.properties = properties;
        this.host = host;
        this.username = username;
        this.password = password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    static {
        DEFAULT_SMTP_PROPERTIES.put("mail.smtp.auth", "true");
        DEFAULT_SMTP_PROPERTIES.put("mail.smtp.starttls.enable", "true");
        DEFAULT_SMTP_PROPERTIES.put("mail.smtp.starttls.required", "true");
        DEFAULT_SMTP_PROPERTIES.put("mail.transport.protocol", "smtp");
        DEFAULT_SMTP_PROPERTIES.put("mail.port", (Object)465);
    }

    public static class Op {
        private final MailSender sender;
        private final Session session;
        private final MimeMessage message;
        private Multipart multipart;

        private Op(MailSender sender) {
            this.sender = sender;
            this.session = Session.getInstance((Properties)sender.properties);
            this.message = new MimeMessage(this.session);
        }

        public Op from(String from) throws MessagingException {
            this.message.setFrom(Op.toAddress(from));
            return this;
        }

        public Op fromPersonal(String personal, String address) throws MessagingException {
            return this.from(Op.toAddressPersonal(personal, address));
        }

        public Op to(String ... to) throws MessagingException {
            if (ObjectUtil.isNotEmpty((Object[])to)) {
                this.message.addRecipients(Message.RecipientType.TO, Op.toAddresses(to));
            }
            return this;
        }

        public Op toPersonal(String personal, String address) throws MessagingException {
            return this.to(Op.toAddressPersonal(personal, address));
        }

        public Op to(List<String> to) throws MessagingException {
            return this.to(to.toArray(new String[0]));
        }

        public Op cc(String ... carbonCopy) throws MessagingException {
            if (ObjectUtil.isNotEmpty((Object[])carbonCopy)) {
                this.message.addRecipients(Message.RecipientType.CC, Op.toAddresses(carbonCopy));
            }
            return this;
        }

        public Op ccPersonal(String personal, String address) throws MessagingException {
            return this.cc(Op.toAddressPersonal(personal, address));
        }

        public Op cc(List<String> carbonCopy) throws MessagingException {
            return this.cc(carbonCopy.toArray(new String[0]));
        }

        public Op bcc(String ... blindCarbonCopy) throws MessagingException {
            if (ObjectUtil.isNotEmpty((Object[])blindCarbonCopy)) {
                this.message.addRecipients(Message.RecipientType.BCC, Op.toAddresses(blindCarbonCopy));
            }
            return this;
        }

        public Op bccPersonal(String personal, String address) throws MessagingException {
            return this.bcc(Op.toAddressPersonal(personal, address));
        }

        public Op bcc(List<String> blindCarbonCopy) throws MessagingException {
            return this.bcc(blindCarbonCopy.toArray(new String[0]));
        }

        public Op replyTo(String ... replyTo) throws MessagingException {
            if (ObjectUtil.isNotEmpty((Object[])replyTo)) {
                this.message.setReplyTo(Op.toAddresses(replyTo));
            }
            return this;
        }

        public Op replyToPersonal(String personal, String address) throws MessagingException {
            return this.replyTo(Op.toAddressPersonal(personal, address));
        }

        public Op replyTo(List<String> replyTo) throws MessagingException {
            return this.replyTo(replyTo.toArray(new String[0]));
        }

        public Op subject(String subject) throws MessagingException {
            this.message.setSubject(subject);
            return this;
        }

        public Op content(String content) throws MessagingException {
            return this.content(content, true);
        }

        public Op content(String content, boolean html) throws MessagingException {
            this.message.setText(content, "utf-8", html ? "html" : "plain");
            return this;
        }

        public Op fileAttachments(Map<String, File> fileAttachments) throws MessagingException {
            for (Map.Entry<String, File> entry : fileAttachments.entrySet()) {
                String attachmentFileName = entry.getKey();
                File file = entry.getValue();
                this.fileAttachment(attachmentFileName, file);
            }
            return this;
        }

        public Op fileAttachment(String filename, File file) throws MessagingException {
            MimeBodyPart attachmentPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(file);
            attachmentPart.setDataHandler(new DataHandler((DataSource)source));
            attachmentPart.setFileName(filename);
            if (this.multipart == null) {
                this.multipart = new MimeMultipart();
            }
            this.multipart.addBodyPart((BodyPart)attachmentPart);
            return this;
        }

        public Op bytesAttachments(Map<String, byte[]> bytesAttachments, String mimeType) throws MessagingException {
            for (Map.Entry<String, byte[]> entry : bytesAttachments.entrySet()) {
                String attachmentFileName = entry.getKey();
                byte[] bytes = entry.getValue();
                this.bytesAttachment(attachmentFileName, bytes, mimeType);
            }
            return this;
        }

        public Op bytesAttachment(String filename, byte[] bytes, String mimeType) throws MessagingException {
            if (mimeType == null) {
                mimeType = MailSender.DEFAULT_BYTES_TYPE;
            }
            MimeBodyPart attachmentPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(bytes, mimeType);
            attachmentPart.setDataHandler(new DataHandler((DataSource)source));
            attachmentPart.setFileName(filename);
            if (this.multipart == null) {
                this.multipart = new MimeMultipart();
            }
            this.multipart.addBodyPart((BodyPart)attachmentPart);
            return this;
        }

        public void send() throws MessagingException {
            this.message.saveChanges();
            try (Transport transport = this.session.getTransport();){
                transport.connect(this.sender.host, this.sender.username, this.sender.password);
                transport.sendMessage((Message)this.message, this.message.getAllRecipients());
            }
        }

        private static String toAddressPersonal(String personal, String address) {
            return personal + "<" + address + ">";
        }

        private static Address toAddress(String address) throws AddressException {
            return new InternetAddress(address);
        }

        private static Address[] toAddresses(String ... addresses) throws AddressException {
            int length = addresses.length;
            Address[] a = new Address[length];
            for (int i = 0; i < length; ++i) {
                a[i] = Op.toAddress(addresses[i]);
            }
            return a;
        }
    }
}

