/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.plot.plotly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dreamcat.common.util.MapUtil;
import org.dreamcat.common.x.jackson.JsonUtil;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.plotly.PlotlyAxis;
import org.dreamcat.common.x.plot.plotly.PlotlyData;
import org.dreamcat.common.x.plot.plotly.PlotlyLayout;
import org.dreamcat.common.x.plot.plotly.PlotlyLine;
import org.dreamcat.common.x.plot.plotly.PlotlyMarker;
import org.dreamcat.common.x.plot.plotly.enums.PlotlyDataMode;

public class Plotly
extends PlotMap {
    private static final String TEMPLATE = "<!DOCTYPE html><html lang=\"en\"><head> <meta charset=\"utf-8\"></head><body><div id='container'></div><script type=\"text/javascript\" src='https://cdn.jsdelivr.net/npm/plotly.js@2.3.1/dist/plotly.min.js'></script><script type=\"text/javascript\"> Plotly.newPlot('container', $data, $layout);</script></body></html>";

    public Plotly addData(PlotlyData data) {
        try {
            this.listMap("data").add(data._value);
        }
        catch (UnsupportedOperationException ignore) {
            ArrayList<Map<String, Object>> mutable = new ArrayList<Map<String, Object>>(this.listMap("data"));
            mutable.add(data._value);
            this._value.put("data", mutable);
        }
        return this;
    }

    public Plotly data(PlotlyData ... data) {
        return this.data(Arrays.asList(data));
    }

    public Plotly data(List<PlotlyData> data) {
        return this.dataRaw(data.stream().map((? super T it) -> it._value).collect(Collectors.toList()));
    }

    public Plotly dataRaw(List<Map<String, Object>> data) {
        this._value.put("data", data);
        return this;
    }

    public Plotly layout(PlotlyLayout layout) {
        return this.layout(layout._value);
    }

    public Plotly layout(Map<String, Object> layout) {
        MapUtil.merge(this.map("layout"), layout);
        return this;
    }

    @Override
    protected Map<String, String> getContext() {
        String data = JsonUtil.toJson(this.listMap("data"));
        String layout = JsonUtil.toJson(this.map("layout"));
        return MapUtil.of((Object[])new Object[]{"data", data, "layout", layout});
    }

    @Override
    protected String getTemplate() {
        return TEMPLATE;
    }

    public static Plotly plotly() {
        return new Plotly();
    }

    public static PlotlyData plotlyData() {
        return new PlotlyData();
    }

    public static PlotlyLayout plotlyLayout() {
        return new PlotlyLayout();
    }

    public static PlotlyAxis plotlyAxis() {
        return new PlotlyAxis();
    }

    public static PlotlyLine plotlyLine() {
        return new PlotlyLine();
    }

    public static PlotlyMarker plotlyMarker() {
        return new PlotlyMarker();
    }

    public static <T> void plotStack(List<?> x, List<long[]> tss, Function<Long, T> mapper, String ... stack) throws IOException {
        ArrayList<PlotlyData> list = new ArrayList<PlotlyData>();
        int i = 0;
        int size = stack.length;
        while (i < size) {
            int seq = i++;
            List y = tss.stream().map((? super T ts) -> ts[seq]).map(mapper).collect(Collectors.toList());
            list.add(Plotly.plotlyData().mode(PlotlyDataMode.lines).x(x).y(y).name(stack[seq]));
        }
        Plotly.plotly().data(list).layout(Plotly.plotlyLayout()).saveHtml().open();
    }
}

