/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.asm;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.dreamcat.common.util.StringUtil;
import org.dreamcat.common.x.asm.MakeField;

public class MakeProperty
extends MakeField {
    final String fieldName;
    String getterSource;
    String setterSource;
    CtClass fieldType;

    MakeProperty(CtField cf, CtClass cc) {
        super(cf, cc);
        this.fieldName = this.fieldInfo.getName();
    }

    @Override
    void afterAdd() throws CannotCompileException {
        if (this.getterSource != null) {
            CtMethod getter = CtMethod.make((String)this.getterSource, (CtClass)this.cc);
            this.cc.addMethod(getter);
        }
        if (this.setterSource != null) {
            CtMethod setter = CtMethod.make((String)this.setterSource, (CtClass)this.cc);
            this.cc.addMethod(setter);
        }
    }

    public MakeProperty makeGetter() throws NotFoundException {
        String literalType = this.getFieldType().getName();
        String prefix = "boolean".equals(literalType) ? "is" : "get";
        return this.makeGetter(prefix);
    }

    public MakeProperty makeGetter(String prefix) throws NotFoundException {
        String literalType = this.getFieldType().getName();
        String capitalFieldName = StringUtil.toCapitalCase((String)this.fieldName);
        this.getterSource = String.format("public %s %s%s(){ return this.%s; }", literalType, prefix, capitalFieldName, this.fieldName);
        return this;
    }

    public MakeProperty makeSetter() throws NotFoundException {
        String literalType = this.getFieldType().getName();
        String capitalFieldName = StringUtil.toCapitalCase((String)this.fieldName);
        this.setterSource = String.format("public void set%s(%s value){ this.%s = value; }", capitalFieldName, literalType, this.fieldName);
        return this;
    }

    private synchronized CtClass getFieldType() throws NotFoundException {
        if (this.fieldType == null) {
            this.fieldType = this.cf.getType();
        }
        return this.fieldType;
    }
}

