/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodParameterUtil.class);

    private MethodParameterUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getName(final Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int len = parameterTypes.length;
        if (len == 0) {
            return new String[0];
        }
        Class<?> clazz = method.getDeclaringClass();
        final String methodName = method.getName();
        final Type[] types = new Type[len];
        for (int i = 0; i < len; ++i) {
            types[i] = Type.getType(parameterTypes[i]);
        }
        final String[] parameterNames = new String[len];
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(lastDotIndex + 1) + ".class";
        try (InputStream inputStream = clazz.getResourceAsStream(className);){
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept(new ClassVisitor(327680){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    Object[] argumentTypes = Type.getArgumentTypes((String)desc);
                    if (!methodName.equals(name) || !Arrays.equals(argumentTypes, types)) {
                        return super.visitMethod(access, name, desc, signature, exceptions);
                    }
                    return new MethodVisitor(327680){

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                            if (Modifier.isStatic(method.getModifiers())) {
                                parameterNames[index] = name;
                            } else if (index > 0) {
                                parameterNames[index - 1] = name;
                            }
                        }
                    };
                }
            }, 0);
            String[] stringArray = parameterNames;
            return stringArray;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String[] getNameByJavassist(Method method) {
        CtMethod ctMethod;
        CtClass ctClass;
        Class<?>[] parameterTypes = method.getParameterTypes();
        int len = parameterTypes.length;
        if (len == 0) {
            return new String[0];
        }
        Class<?> clazz = method.getDeclaringClass();
        String methodName = method.getName();
        ClassPool pool = ClassPool.getDefault();
        try {
            ctClass = pool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        CtClass[] params = new CtClass[len];
        for (int i = 0; i < len; ++i) {
            try {
                params[i] = pool.get(parameterTypes[i].getName());
                continue;
            }
            catch (NotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            ctMethod = ctClass.getDeclaredMethod(methodName, params);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (attribute == null) {
            return null;
        }
        String[] parameterNames = new String[len];
        int pos = Modifier.isStatic(ctMethod.getModifiers()) ? 0 : 1;
        for (int i = 0; i < len; ++i) {
            parameterNames[i] = attribute.variableName(i + pos);
        }
        return parameterNames;
    }
}

