/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.dreamcat.common.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanMapUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanMapUtil.class);

    private BeanMapUtil() {
    }

    public static Map<String, Object> toMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanMap beanMap = BeanMap.create((Object)bean);
        beanMap.forEach((k, v) -> map.put(k.toString(), v));
        return map;
    }

    public static Map<String, Object> toMapDeeply(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanMap beanMap = BeanMap.create((Object)bean);
        beanMap.forEach((k, v) -> {
            if (!ReflectUtil.isJsonType((Object)v)) {
                v = BeanMapUtil.toMapDeeply(v);
            }
            map.put((String)k, v);
        });
        return map;
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz) {
        Object bean = ReflectUtil.newInstance(clazz);
        BeanMap beanMap = BeanMap.create((Object)bean);
        map.forEach((k, v) -> {
            Object newV = ReflectUtil.cast((Object)v, (Class)beanMap.getPropertyType(k));
            beanMap.put(k, newV);
        });
        return (T)bean;
    }

    public static List toList(Object bean) {
        BeanMap beanMap = BeanMap.create((Object)bean);
        return new ArrayList(beanMap.values());
    }

    public static <T> T copy(T bean, Class<T> clazz) {
        Object targetBean = ReflectUtil.newInstance(clazz);
        BeanMapUtil.copy(bean, targetBean);
        return (T)targetBean;
    }

    public static <T> void copy(T source, T target) {
        BeanMap sourceBeanMap = BeanMap.create(source);
        BeanMap targetBeanMap = BeanMap.create(target);
        targetBeanMap.putAll((Map)sourceBeanMap);
    }

    public static Object getProperty(Object bean, String name) {
        BeanMap beanMap = BeanMap.create((Object)bean);
        return beanMap.get((Object)name);
    }
}

