/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.dreamcat.common.util.ReflectUtil;
import org.dreamcat.common.x.jackson.GenericDeserialize;
import org.dreamcat.common.x.jackson.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private static final Logger log = LoggerFactory.getLogger(GenericDeserializer.class);
    private Class<?> type;
    private Class<?> componentType;
    private ZoneId zoneId;

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.type.equals(List.class) || this.type.isArray()) {
            List list = (List)p.readValueAs(List.class);
            ArrayList<Object> value = new ArrayList<Object>(list.size());
            for (Object e : list) {
                if (e == null) {
                    return null;
                }
                value.add(GenericDeserializer.map(e, this.componentType, this.zoneId));
            }
            if (this.type.isArray()) {
                return value.toArray((Object[])Array.newInstance(this.componentType, value.size()));
            }
            return value;
        }
        return GenericDeserializer.map(p.readValueAs(Object.class), this.type, this.zoneId);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return this;
        }
        GenericDeserialize genericDeserialize = (GenericDeserialize)property.getAnnotation(GenericDeserialize.class);
        if (genericDeserialize == null) {
            genericDeserialize = (GenericDeserialize)property.getContextAnnotation(GenericDeserialize.class);
        }
        if (genericDeserialize == null) {
            return ctxt.findNonContextualValueDeserializer(property.getType());
        }
        Class rawClass = property.getType().getRawClass();
        Class<?> rawComponentType = genericDeserialize.componentType();
        ZoneId rawZoneId = ZoneId.of(genericDeserialize.zoneId());
        return new GenericDeserializer(rawClass, rawComponentType, rawZoneId);
    }

    private static Object map(Object value, Class<?> type, ZoneId zoneId) {
        block8: {
            try {
                Object parsed;
                if (value instanceof String) {
                    String s = (String)value;
                    return GenericDeserializer.castStr(s, type);
                }
                if (value instanceof Integer || value instanceof Long) {
                    long n = ((Number)value).longValue();
                    return GenericDeserializer.castInt(n, type, zoneId);
                }
                if (value instanceof Double) {
                    double n = (Double)value;
                    Object parsed2 = ReflectUtil.parse((double)n, type);
                    if (parsed2 != null) {
                        return parsed2;
                    }
                } else if (value instanceof Boolean && (parsed = ReflectUtil.parse((Object)((Boolean)value), type)) != null) {
                    return parsed;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.warn("failed to cast '{}' to {}: {}", new Object[]{value, type, e.getMessage()});
            }
        }
        return null;
    }

    private static Object castStr(String s, Class<?> type) {
        Object parsed;
        if (type.isEnum() && Supplier.class.isAssignableFrom(type)) {
            ?[] enums;
            for (Object e : enums = type.getEnumConstants()) {
                if (!s.equals(((Supplier)e).get())) continue;
                return e;
            }
        }
        if ((parsed = ReflectUtil.parse((String)s, type)) != null) {
            return parsed;
        }
        return JsonUtil.fromJson(s, type);
    }

    private static Object castInt(long n, Class<?> type, ZoneId zoneId) {
        block8: {
            Object parsed = ReflectUtil.parse((long)n, type, (ZoneId)zoneId);
            if (parsed != null) {
                return parsed;
            }
            if (!type.isEnum()) break block8;
            ?[] enums = type.getEnumConstants();
            if (Supplier.class.isAssignableFrom(type)) {
                for (Object e : enums) {
                    Object v = ((Supplier)e).get();
                    if (!(v instanceof Number) || ((Number)v).longValue() != n) continue;
                    return e;
                }
            } else if (IntSupplier.class.isAssignableFrom(type)) {
                for (Object e : enums) {
                    int v = ((IntSupplier)e).getAsInt();
                    if ((long)v != n) continue;
                    return e;
                }
            } else {
                for (Object e : enums) {
                    int ordinal = ((Enum)e).ordinal();
                    if ((long)ordinal != n) continue;
                    return e;
                }
            }
        }
        return null;
    }

    public GenericDeserializer() {
    }

    public GenericDeserializer(Class<?> type, Class<?> componentType, ZoneId zoneId) {
        this.type = type;
        this.componentType = componentType;
        this.zoneId = zoneId;
    }
}

