/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.dreamcat.common.util.DateUtil;
import org.dreamcat.common.x.jackson.GenericSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(GenericSerializer.class);
    private ZoneId zoneId;
    private boolean longCast;
    private boolean booleanCast;

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            gen.writeStartArray();
            for (Object i : collection) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof long[]) {
            long[] array = (long[])value;
            gen.writeStartArray();
            for (long i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof int[]) {
            int[] array = (int[])value;
            gen.writeStartArray();
            for (int i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof double[]) {
            double[] array = (double[])value;
            gen.writeStartArray();
            for (double i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof short[]) {
            short[] array = (short[])value;
            gen.writeStartArray();
            for (short i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            gen.writeStartArray();
            for (byte i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof float[]) {
            float[] array = (float[])value;
            gen.writeStartArray();
            for (float i : array) {
                this.mapAndWrite(gen, Float.valueOf(i));
            }
            gen.writeEndArray();
        } else if (value instanceof char[]) {
            char[] array = (char[])value;
            gen.writeStartArray();
            for (char i : array) {
                this.mapAndWrite(gen, Character.valueOf(i));
            }
            gen.writeEndArray();
        } else if (value instanceof boolean[]) {
            boolean[] array = (boolean[])value;
            gen.writeStartArray();
            for (boolean i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            gen.writeStartArray();
            for (Object i : array) {
                this.mapAndWrite(gen, i);
            }
            gen.writeEndArray();
        } else {
            this.mapAndWrite(gen, value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return this;
        }
        GenericSerialize genericSerialize = (GenericSerialize)property.getAnnotation(GenericSerialize.class);
        if (genericSerialize == null) {
            genericSerialize = (GenericSerialize)property.getContextAnnotation(GenericSerialize.class);
        }
        if (genericSerialize == null) {
            return prov.findContentValueSerializer(property.getType(), property);
        }
        ZoneId rawZoneId = ZoneId.of(genericSerialize.zoneId());
        boolean rawLongCast = genericSerialize.longCast();
        boolean rawBooleanCast = genericSerialize.booleanCast();
        return new GenericSerializer(rawZoneId, rawLongCast, rawBooleanCast);
    }

    private void mapAndWrite(JsonGenerator gen, Object value) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else if (value instanceof Boolean) {
            if (this.booleanCast) {
                gen.writeNumber((Boolean)value != false ? 1 : 0);
            } else {
                gen.writeBoolean(((Boolean)value).booleanValue());
            }
        } else if (value instanceof Long) {
            if (this.longCast) {
                gen.writeString(Long.toString((Long)value));
            } else {
                gen.writeNumber(((Long)value).longValue());
            }
        } else if (value instanceof Number) {
            gen.writeNumber(((Number)value).longValue());
        } else if (value instanceof Date) {
            gen.writeNumber(((Date)value).getTime());
        } else if (value instanceof LocalDateTime) {
            long epochMilli = DateUtil.asEpochMilli((LocalDateTime)((LocalDateTime)value), (ZoneId)this.zoneId);
            gen.writeNumber(epochMilli);
        } else if (value instanceof LocalDate) {
            long epochMilli = DateUtil.asEpochMilli((LocalDateTime)((LocalDate)value).atStartOfDay(), (ZoneId)this.zoneId);
            gen.writeNumber(epochMilli);
        } else if (value instanceof Supplier) {
            Object enumValue = ((Supplier)value).get();
            if (enumValue instanceof Number) {
                gen.writeNumber(((Number)enumValue).longValue());
            } else if (enumValue instanceof String) {
                gen.writeString((String)enumValue);
            } else {
                gen.writeNull();
            }
        } else if (value instanceof IntSupplier) {
            int n = ((IntSupplier)value).getAsInt();
            gen.writeNumber(n);
        } else if (value instanceof Enum) {
            String enumValue = ((Enum)value).name();
            gen.writeString(enumValue);
        } else {
            gen.writeString(value.toString());
        }
    }

    public GenericSerializer() {
    }

    public GenericSerializer(ZoneId zoneId, boolean longCast, boolean booleanCast) {
        this.zoneId = zoneId;
        this.longCast = longCast;
        this.booleanCast = booleanCast;
    }
}

