/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;

public class OneOrManyDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private JavaType type;

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (!node.isArray()) {
            ArrayNode arrayNode = new ArrayNode(ctxt.getNodeFactory());
            arrayNode.add(node);
            node = arrayNode;
        }
        return ctxt.readTreeAsValue(node, this.type);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        if (property == null) {
            return this;
        }
        JavaType javaType = property.getType();
        return new OneOrManyDeserializer(javaType);
    }

    public OneOrManyDeserializer() {
    }

    public OneOrManyDeserializer(JavaType type) {
        this.type = type;
    }
}

