/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dreamcat.common.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
    private static final ObjectMapper objectMapper = (ObjectMapper)ReflectUtil.newInstance((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper");

    private XmlUtil() {
    }

    public static void findAndRegisterModules() {
        XmlUtil.registerModules(ObjectMapper.findModules());
    }

    public static void registerModules(Iterable<? extends Module> modules) {
        objectMapper.registerModules(modules);
    }

    public static void configure(Consumer<ObjectMapper> configurator) {
        configurator.accept(objectMapper);
    }

    public static void useFieldVisibilityOnly() {
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    public static <T> Map<String, Object> toMap(T bean) {
        return (Map)objectMapper.convertValue(bean, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static <T> T fromMap(Map<?, ?> map, Class<?> genericClass, Class<?> ... parameterTypes) {
        return (T)objectMapper.convertValue(map, XmlUtil.getGenericType(genericClass, parameterTypes));
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(byte[] json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(File file, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(URL url, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(url, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(Reader reader, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(reader, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(inputStream, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(String json) {
        return XmlUtil.fromJson(json, Map.class);
    }

    public static Map<String, Object> fromJsonObject(byte[] json) {
        return XmlUtil.fromJson(json, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(String json, Class<V> valueType) {
        try {
            JavaType javaType = XmlUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(File file) {
        return XmlUtil.fromJson(file, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(File file, Class<V> valueType) {
        try {
            JavaType javaType = XmlUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(file, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(URL url) {
        return XmlUtil.fromJson(url, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(URL url, Class<V> valueType) {
        try {
            JavaType javaType = XmlUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(url, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> fromJsonObject(Reader reader) {
        return XmlUtil.fromJson(reader, Map.class);
    }

    public static <V> Map<String, V> fromJsonObject(Reader reader, Class<V> valueType) {
        try {
            JavaType javaType = XmlUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(reader, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <V> Map<String, V> fromJsonObject(InputStream inputStream, Class<V> valueType) {
        try {
            JavaType javaType = XmlUtil.getGenericType(Map.class, String.class, valueType);
            return (Map)objectMapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(json, XmlUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(byte[] json, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(json, XmlUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(File file, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(file, XmlUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(URL url, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(url, XmlUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(Reader reader, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(reader, XmlUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static <T> List<T> fromJsonArray(InputStream inputStream, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(inputStream, XmlUtil.getGenericType(ArrayList.class, clazz));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String toJson(Object bean) {
        try {
            return objectMapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static byte[] toJsonBytes(Object bean) {
        try {
            return objectMapper.writeValueAsBytes(bean);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static boolean writeJson(Object bean, File file) {
        try {
            objectMapper.writeValue(file, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeJson(Object bean, Writer writer) {
        try {
            objectMapper.writeValue(writer, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static boolean writeJson(Object bean, OutputStream outputStream) {
        try {
            objectMapper.writeValue(outputStream, bean);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static JsonNode toJsonTree(String json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static JsonNode toJsonTree(byte[] json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static JsonNode toJsonTree(File file) {
        try {
            return objectMapper.readTree(file);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static JsonNode toJsonTree(URL url) {
        try {
            return objectMapper.readTree(url);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static JsonNode toJsonTree(Reader reader) {
        try {
            return objectMapper.readTree(reader);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static JsonNode toJsonTree(InputStream inputStream) {
        try {
            return objectMapper.readTree(inputStream);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Integer getInt(String json, String memberName) {
        return XmlUtil.getInt(XmlUtil.toJsonTree(json), memberName);
    }

    public static Integer getInt(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asInt();
        }
        return null;
    }

    public static Long getLong(String json, String memberName) {
        return XmlUtil.getLong(XmlUtil.toJsonTree(json), memberName);
    }

    public static Long getLong(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asLong();
        }
        return null;
    }

    public static Double getDouble(String json, String memberName) {
        return XmlUtil.getDouble(XmlUtil.toJsonTree(json), memberName);
    }

    public static Double getDouble(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asDouble();
        }
        return null;
    }

    public static String getString(String json, String memberName) {
        return XmlUtil.getString(XmlUtil.toJsonTree(json), memberName);
    }

    public static String getString(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asText();
        }
        return null;
    }

    public static Boolean getBoolean(String json, String memberName) {
        return XmlUtil.getBoolean(XmlUtil.toJsonTree(json), memberName);
    }

    public static Boolean getBoolean(JsonNode tree, String memberName) {
        JsonNode member;
        if (tree != null && tree.isObject() && (member = tree.get(memberName)).isNumber()) {
            return member.asBoolean();
        }
        return null;
    }

    public static JavaType getGenericType(Class<?> genericClass, Class<?> ... parameterTypes) {
        return objectMapper.getTypeFactory().constructParametricType(genericClass, (Class[])parameterTypes);
    }

    static {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

