/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.common.x.plot.echart;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dreamcat.common.util.MapUtil;
import org.dreamcat.common.x.jackson.JsonUtil;
import org.dreamcat.common.x.plot.PlotMap;
import org.dreamcat.common.x.plot.echart.ECAreaStyle;
import org.dreamcat.common.x.plot.echart.ECAxis;
import org.dreamcat.common.x.plot.echart.ECAxisValue;
import org.dreamcat.common.x.plot.echart.ECLegend;
import org.dreamcat.common.x.plot.echart.ECLegendValue;
import org.dreamcat.common.x.plot.echart.ECSeries;
import org.dreamcat.common.x.plot.echart.ECSeriesValue;
import org.dreamcat.common.x.plot.echart.ECTitle;
import org.dreamcat.common.x.plot.echart.ECTooltip;

public class ECharts
extends PlotMap {
    private static final String TEMPLATE = "<!DOCTYPE html><html style=\"height: 100%\" lang=\"en\"> <head> <meta charset=\"utf-8\"> </head> <body style=\"height: 100%; margin: 0\"> <div id=\"container\" style=\"height: 100%\"></div> <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/echarts@5/dist/echarts.min.js\"></script> <script type=\"text/javascript\">var dom = document.getElementById(\"container\");var myChart = echarts.init(dom);var option = $option;if (option && typeof option === 'object') { myChart.setOption(option);} </script> </body></html>";

    public ECharts title(Map<String, Object> title) {
        MapUtil.merge(this.map("title"), title);
        return this;
    }

    public ECharts title(ECTitle title) {
        return this.title(title._value);
    }

    public ECharts tooltip(Map<String, Object> tooltip) {
        MapUtil.merge(this.map("tooltip"), tooltip);
        return this;
    }

    public ECharts tooltip(ECTooltip tooltip) {
        return this.tooltip(tooltip._value);
    }

    public ECharts legend(Map<String, Object> legend) {
        MapUtil.merge(this.map("legend"), legend);
        return this;
    }

    public ECharts legend(ECLegend legend) {
        return this.legend(legend._value);
    }

    public ECharts xAxis(Map<String, Object> xAxis) {
        MapUtil.merge(this.map("xAxis"), xAxis);
        return this;
    }

    public ECharts xAxis(ECAxis xAxis) {
        return this.xAxis(xAxis._value);
    }

    public ECharts yAxis(Map<String, Object> yAxis) {
        MapUtil.merge(this.map("yAxis"), yAxis);
        return this;
    }

    public ECharts yAxis(ECAxis yAxis) {
        return this.yAxis(yAxis._value);
    }

    public ECharts seriesRaw(List<Map<String, Object>> series) {
        this._value.put("series", series);
        return this;
    }

    public ECharts series(ECSeries ... series) {
        return this.series(Arrays.asList(series));
    }

    public ECharts series(List<ECSeries> series) {
        return this.seriesRaw(series.stream().map((? super T it) -> it._value).collect(Collectors.toList()));
    }

    @Override
    protected Map<String, String> getContext() {
        String option = JsonUtil.toJson(this._value);
        return MapUtil.of((Object[])new Object[]{"option", option});
    }

    @Override
    protected String getTemplate() {
        return TEMPLATE;
    }

    public static ECharts echarts() {
        return new ECharts();
    }

    public static ECAxis xAxis() {
        return new ECAxis();
    }

    public static ECAxis yAxis() {
        return new ECAxis();
    }

    public static ECAxisValue axisValue() {
        return new ECAxisValue();
    }

    public static ECSeries series() {
        return new ECSeries();
    }

    public static ECSeriesValue seriesValue() {
        return new ECSeriesValue();
    }

    public static ECAreaStyle areaStyle() {
        return new ECAreaStyle();
    }

    public static ECTooltip tooltip() {
        return new ECTooltip();
    }

    public static ECLegend legend() {
        return new ECLegend();
    }

    public static ECLegendValue legendValue() {
        return new ECLegendValue();
    }
}

