/*
 * Decompiled with CFR 0.152.
 */
package org.dreamcat.injection.test;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import org.dreamcat.injection.test.context.TestContextManager;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class InjectionExtension
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace TEST_CONTEXT_MANAGER_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{InjectionExtension.class});

    public void beforeAll(ExtensionContext context) throws Exception {
        InjectionExtension.getTestContextManager(context).beforeTestClass();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        try {
            InjectionExtension.getTestContextManager(context).afterTestClass();
        }
        finally {
            InjectionExtension.getStore(context).remove((Object)context.getRequiredTestClass());
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        InjectionExtension.getTestContextManager(context).prepareTestInstance(testInstance);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        InjectionExtension.getTestContextManager(context).beforeTestMethod(testInstance, testMethod);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        InjectionExtension.getTestContextManager(context).afterTestMethod(testInstance, testMethod, testException);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        InjectionExtension.getTestContextManager(context).beforeTestExecution(testInstance, testMethod);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        InjectionExtension.getTestContextManager(context).afterTestExecution(testInstance, testMethod, testException);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Executable executable = parameter.getDeclaringExecutable();
        Class testClass = extensionContext.getRequiredTestClass();
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        Class testClass = extensionContext.getRequiredTestClass();
        return null;
    }

    static TestContextManager getTestContextManager(ExtensionContext context) {
        Objects.requireNonNull(context, "ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = InjectionExtension.getStore(context);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(TEST_CONTEXT_MANAGER_NAMESPACE);
    }
}

